/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.networking.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelectorPatch;
import com.pulumi.kubernetes.networking.v1.outputs.NetworkPolicyEgressRulePatch;
import com.pulumi.kubernetes.networking.v1.outputs.NetworkPolicyIngressRulePatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class NetworkPolicySpecPatch {
    @Nullable
    private List<NetworkPolicyEgressRulePatch> egress;
    @Nullable
    private List<NetworkPolicyIngressRulePatch> ingress;
    @Nullable
    private LabelSelectorPatch podSelector;
    @Nullable
    private List<String> policyTypes;

    private NetworkPolicySpecPatch() {
    }

    public List<NetworkPolicyEgressRulePatch> egress() {
        return this.egress == null ? List.of() : this.egress;
    }

    public List<NetworkPolicyIngressRulePatch> ingress() {
        return this.ingress == null ? List.of() : this.ingress;
    }

    public Optional<LabelSelectorPatch> podSelector() {
        return Optional.ofNullable(this.podSelector);
    }

    public List<String> policyTypes() {
        return this.policyTypes == null ? List.of() : this.policyTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NetworkPolicySpecPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<NetworkPolicyEgressRulePatch> egress;
        @Nullable
        private List<NetworkPolicyIngressRulePatch> ingress;
        @Nullable
        private LabelSelectorPatch podSelector;
        @Nullable
        private List<String> policyTypes;

        public Builder() {
        }

        public Builder(NetworkPolicySpecPatch defaults) {
            Objects.requireNonNull(defaults);
            this.egress = defaults.egress;
            this.ingress = defaults.ingress;
            this.podSelector = defaults.podSelector;
            this.policyTypes = defaults.policyTypes;
        }

        @CustomType.Setter
        public Builder egress(@Nullable List<NetworkPolicyEgressRulePatch> egress) {
            this.egress = egress;
            return this;
        }

        public Builder egress(NetworkPolicyEgressRulePatch ... egress) {
            return this.egress(List.of(egress));
        }

        @CustomType.Setter
        public Builder ingress(@Nullable List<NetworkPolicyIngressRulePatch> ingress) {
            this.ingress = ingress;
            return this;
        }

        public Builder ingress(NetworkPolicyIngressRulePatch ... ingress) {
            return this.ingress(List.of(ingress));
        }

        @CustomType.Setter
        public Builder podSelector(@Nullable LabelSelectorPatch podSelector) {
            this.podSelector = podSelector;
            return this;
        }

        @CustomType.Setter
        public Builder policyTypes(@Nullable List<String> policyTypes) {
            this.policyTypes = policyTypes;
            return this;
        }

        public Builder policyTypes(String ... policyTypes) {
            return this.policyTypes(List.of(policyTypes));
        }

        public NetworkPolicySpecPatch build() {
            NetworkPolicySpecPatch _resultValue = new NetworkPolicySpecPatch();
            _resultValue.egress = this.egress;
            _resultValue.ingress = this.ingress;
            _resultValue.podSelector = this.podSelector;
            _resultValue.policyTypes = this.policyTypes;
            return _resultValue;
        }
    }
}

