/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.node.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.node.v1alpha1.outputs.RuntimeClassSpec;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RuntimeClass {
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    private RuntimeClassSpec spec;

    private RuntimeClass() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public RuntimeClassSpec spec() {
        return this.spec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RuntimeClass defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        private RuntimeClassSpec spec;

        public Builder() {
        }

        public Builder(RuntimeClass defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.spec = defaults.spec;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder spec(RuntimeClassSpec spec) {
            if (spec == null) {
                throw new MissingRequiredPropertyException("RuntimeClass", "spec");
            }
            this.spec = spec;
            return this;
        }

        public RuntimeClass build() {
            RuntimeClass _resultValue = new RuntimeClass();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.spec = this.spec;
            return _resultValue;
        }
    }
}

