/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.node.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.node.v1alpha1.outputs.Overhead;
import com.pulumi.kubernetes.node.v1alpha1.outputs.Scheduling;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RuntimeClassSpec {
    @Nullable
    private Overhead overhead;
    private String runtimeHandler;
    @Nullable
    private Scheduling scheduling;

    private RuntimeClassSpec() {
    }

    public Optional<Overhead> overhead() {
        return Optional.ofNullable(this.overhead);
    }

    public String runtimeHandler() {
        return this.runtimeHandler;
    }

    public Optional<Scheduling> scheduling() {
        return Optional.ofNullable(this.scheduling);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RuntimeClassSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Overhead overhead;
        private String runtimeHandler;
        @Nullable
        private Scheduling scheduling;

        public Builder() {
        }

        public Builder(RuntimeClassSpec defaults) {
            Objects.requireNonNull(defaults);
            this.overhead = defaults.overhead;
            this.runtimeHandler = defaults.runtimeHandler;
            this.scheduling = defaults.scheduling;
        }

        @CustomType.Setter
        public Builder overhead(@Nullable Overhead overhead) {
            this.overhead = overhead;
            return this;
        }

        @CustomType.Setter
        public Builder runtimeHandler(String runtimeHandler) {
            if (runtimeHandler == null) {
                throw new MissingRequiredPropertyException("RuntimeClassSpec", "runtimeHandler");
            }
            this.runtimeHandler = runtimeHandler;
            return this;
        }

        @CustomType.Setter
        public Builder scheduling(@Nullable Scheduling scheduling) {
            this.scheduling = scheduling;
            return this;
        }

        public RuntimeClassSpec build() {
            RuntimeClassSpec _resultValue = new RuntimeClassSpec();
            _resultValue.overhead = this.overhead;
            _resultValue.runtimeHandler = this.runtimeHandler;
            _resultValue.scheduling = this.scheduling;
            return _resultValue;
        }
    }
}

