/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.policy.v1.outputs;

import com.pulumi.core.Either;
import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodDisruptionBudgetSpec {
    @Nullable
    private Either<Integer, String> maxUnavailable;
    @Nullable
    private Either<Integer, String> minAvailable;
    @Nullable
    private LabelSelector selector;
    @Nullable
    private String unhealthyPodEvictionPolicy;

    private PodDisruptionBudgetSpec() {
    }

    public Optional<Either<Integer, String>> maxUnavailable() {
        return Optional.ofNullable(this.maxUnavailable);
    }

    public Optional<Either<Integer, String>> minAvailable() {
        return Optional.ofNullable(this.minAvailable);
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public Optional<String> unhealthyPodEvictionPolicy() {
        return Optional.ofNullable(this.unhealthyPodEvictionPolicy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodDisruptionBudgetSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Either<Integer, String> maxUnavailable;
        @Nullable
        private Either<Integer, String> minAvailable;
        @Nullable
        private LabelSelector selector;
        @Nullable
        private String unhealthyPodEvictionPolicy;

        public Builder() {
        }

        public Builder(PodDisruptionBudgetSpec defaults) {
            Objects.requireNonNull(defaults);
            this.maxUnavailable = defaults.maxUnavailable;
            this.minAvailable = defaults.minAvailable;
            this.selector = defaults.selector;
            this.unhealthyPodEvictionPolicy = defaults.unhealthyPodEvictionPolicy;
        }

        @CustomType.Setter
        public Builder maxUnavailable(@Nullable Either<Integer, String> maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
            return this;
        }

        @CustomType.Setter
        public Builder minAvailable(@Nullable Either<Integer, String> minAvailable) {
            this.minAvailable = minAvailable;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder unhealthyPodEvictionPolicy(@Nullable String unhealthyPodEvictionPolicy) {
            this.unhealthyPodEvictionPolicy = unhealthyPodEvictionPolicy;
            return this;
        }

        public PodDisruptionBudgetSpec build() {
            PodDisruptionBudgetSpec _resultValue = new PodDisruptionBudgetSpec();
            _resultValue.maxUnavailable = this.maxUnavailable;
            _resultValue.minAvailable = this.minAvailable;
            _resultValue.selector = this.selector;
            _resultValue.unhealthyPodEvictionPolicy = this.unhealthyPodEvictionPolicy;
            return _resultValue;
        }
    }
}

