/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.policy.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.Condition;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodDisruptionBudgetStatus {
    @Nullable
    private List<Condition> conditions;
    private Integer currentHealthy;
    private Integer desiredHealthy;
    @Nullable
    private Map<String, String> disruptedPods;
    private Integer disruptionsAllowed;
    private Integer expectedPods;
    @Nullable
    private Integer observedGeneration;

    private PodDisruptionBudgetStatus() {
    }

    public List<Condition> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }

    public Integer currentHealthy() {
        return this.currentHealthy;
    }

    public Integer desiredHealthy() {
        return this.desiredHealthy;
    }

    public Map<String, String> disruptedPods() {
        return this.disruptedPods == null ? Map.of() : this.disruptedPods;
    }

    public Integer disruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    public Integer expectedPods() {
        return this.expectedPods;
    }

    public Optional<Integer> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodDisruptionBudgetStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<Condition> conditions;
        private Integer currentHealthy;
        private Integer desiredHealthy;
        @Nullable
        private Map<String, String> disruptedPods;
        private Integer disruptionsAllowed;
        private Integer expectedPods;
        @Nullable
        private Integer observedGeneration;

        public Builder() {
        }

        public Builder(PodDisruptionBudgetStatus defaults) {
            Objects.requireNonNull(defaults);
            this.conditions = defaults.conditions;
            this.currentHealthy = defaults.currentHealthy;
            this.desiredHealthy = defaults.desiredHealthy;
            this.disruptedPods = defaults.disruptedPods;
            this.disruptionsAllowed = defaults.disruptionsAllowed;
            this.expectedPods = defaults.expectedPods;
            this.observedGeneration = defaults.observedGeneration;
        }

        @CustomType.Setter
        public Builder conditions(@Nullable List<Condition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(Condition ... conditions) {
            return this.conditions(List.of(conditions));
        }

        @CustomType.Setter
        public Builder currentHealthy(Integer currentHealthy) {
            if (currentHealthy == null) {
                throw new MissingRequiredPropertyException("PodDisruptionBudgetStatus", "currentHealthy");
            }
            this.currentHealthy = currentHealthy;
            return this;
        }

        @CustomType.Setter
        public Builder desiredHealthy(Integer desiredHealthy) {
            if (desiredHealthy == null) {
                throw new MissingRequiredPropertyException("PodDisruptionBudgetStatus", "desiredHealthy");
            }
            this.desiredHealthy = desiredHealthy;
            return this;
        }

        @CustomType.Setter
        public Builder disruptedPods(@Nullable Map<String, String> disruptedPods) {
            this.disruptedPods = disruptedPods;
            return this;
        }

        @CustomType.Setter
        public Builder disruptionsAllowed(Integer disruptionsAllowed) {
            if (disruptionsAllowed == null) {
                throw new MissingRequiredPropertyException("PodDisruptionBudgetStatus", "disruptionsAllowed");
            }
            this.disruptionsAllowed = disruptionsAllowed;
            return this;
        }

        @CustomType.Setter
        public Builder expectedPods(Integer expectedPods) {
            if (expectedPods == null) {
                throw new MissingRequiredPropertyException("PodDisruptionBudgetStatus", "expectedPods");
            }
            this.expectedPods = expectedPods;
            return this;
        }

        @CustomType.Setter
        public Builder observedGeneration(@Nullable Integer observedGeneration) {
            this.observedGeneration = observedGeneration;
            return this;
        }

        public PodDisruptionBudgetStatus build() {
            PodDisruptionBudgetStatus _resultValue = new PodDisruptionBudgetStatus();
            _resultValue.conditions = this.conditions;
            _resultValue.currentHealthy = this.currentHealthy;
            _resultValue.desiredHealthy = this.desiredHealthy;
            _resultValue.disruptedPods = this.disruptedPods;
            _resultValue.disruptionsAllowed = this.disruptionsAllowed;
            _resultValue.expectedPods = this.expectedPods;
            _resultValue.observedGeneration = this.observedGeneration;
            return _resultValue;
        }
    }
}

