/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.rbac.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.rbac.v1.outputs.AggregationRule;
import com.pulumi.kubernetes.rbac.v1.outputs.PolicyRule;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterRole {
    @Nullable
    private AggregationRule aggregationRule;
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private List<PolicyRule> rules;

    private ClusterRole() {
    }

    public Optional<AggregationRule> aggregationRule() {
        return Optional.ofNullable(this.aggregationRule);
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public List<PolicyRule> rules() {
        return this.rules == null ? List.of() : this.rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterRole defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private AggregationRule aggregationRule;
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private List<PolicyRule> rules;

        public Builder() {
        }

        public Builder(ClusterRole defaults) {
            Objects.requireNonNull(defaults);
            this.aggregationRule = defaults.aggregationRule;
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.rules = defaults.rules;
        }

        @CustomType.Setter
        public Builder aggregationRule(@Nullable AggregationRule aggregationRule) {
            this.aggregationRule = aggregationRule;
            return this;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder rules(@Nullable List<PolicyRule> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(PolicyRule ... rules) {
            return this.rules(List.of(rules));
        }

        public ClusterRole build() {
            ClusterRole _resultValue = new ClusterRole();
            _resultValue.aggregationRule = this.aggregationRule;
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.rules = this.rules;
            return _resultValue;
        }
    }
}

