/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.rbac.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.rbac.v1.outputs.RoleRef;
import com.pulumi.kubernetes.rbac.v1.outputs.Subject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterRoleBinding {
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    private RoleRef roleRef;
    @Nullable
    private List<Subject> subjects;

    private ClusterRoleBinding() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public RoleRef roleRef() {
        return this.roleRef;
    }

    public List<Subject> subjects() {
        return this.subjects == null ? List.of() : this.subjects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterRoleBinding defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        private RoleRef roleRef;
        @Nullable
        private List<Subject> subjects;

        public Builder() {
        }

        public Builder(ClusterRoleBinding defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.roleRef = defaults.roleRef;
            this.subjects = defaults.subjects;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder roleRef(RoleRef roleRef) {
            if (roleRef == null) {
                throw new MissingRequiredPropertyException("ClusterRoleBinding", "roleRef");
            }
            this.roleRef = roleRef;
            return this;
        }

        @CustomType.Setter
        public Builder subjects(@Nullable List<Subject> subjects) {
            this.subjects = subjects;
            return this;
        }

        public Builder subjects(Subject ... subjects) {
            return this.subjects(List.of(subjects));
        }

        public ClusterRoleBinding build() {
            ClusterRoleBinding _resultValue = new ClusterRoleBinding();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.roleRef = this.roleRef;
            _resultValue.subjects = this.subjects;
            return _resultValue;
        }
    }
}

