/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.NodeSelector;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.resource.v1alpha1.outputs.ResourceClassParametersReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceClass {
    @Nullable
    private String apiVersion;
    private String driverName;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private ResourceClassParametersReference parametersRef;
    @Nullable
    private NodeSelector suitableNodes;

    private ResourceClass() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public String driverName() {
        return this.driverName;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<ResourceClassParametersReference> parametersRef() {
        return Optional.ofNullable(this.parametersRef);
    }

    public Optional<NodeSelector> suitableNodes() {
        return Optional.ofNullable(this.suitableNodes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceClass defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        private String driverName;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private ResourceClassParametersReference parametersRef;
        @Nullable
        private NodeSelector suitableNodes;

        public Builder() {
        }

        public Builder(ResourceClass defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.driverName = defaults.driverName;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.parametersRef = defaults.parametersRef;
            this.suitableNodes = defaults.suitableNodes;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder driverName(String driverName) {
            if (driverName == null) {
                throw new MissingRequiredPropertyException("ResourceClass", "driverName");
            }
            this.driverName = driverName;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder parametersRef(@Nullable ResourceClassParametersReference parametersRef) {
            this.parametersRef = parametersRef;
            return this;
        }

        @CustomType.Setter
        public Builder suitableNodes(@Nullable NodeSelector suitableNodes) {
            this.suitableNodes = suitableNodes;
            return this;
        }

        public ResourceClass build() {
            ResourceClass _resultValue = new ResourceClass();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.driverName = this.driverName;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.parametersRef = this.parametersRef;
            _resultValue.suitableNodes = this.suitableNodes;
            return _resultValue;
        }
    }
}

