/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.NodeSelector;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.ResourceHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AllocationResult {
    @Nullable
    private NodeSelector availableOnNodes;
    @Nullable
    private List<ResourceHandle> resourceHandles;
    @Nullable
    private Boolean shareable;

    private AllocationResult() {
    }

    public Optional<NodeSelector> availableOnNodes() {
        return Optional.ofNullable(this.availableOnNodes);
    }

    public List<ResourceHandle> resourceHandles() {
        return this.resourceHandles == null ? List.of() : this.resourceHandles;
    }

    public Optional<Boolean> shareable() {
        return Optional.ofNullable(this.shareable);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AllocationResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private NodeSelector availableOnNodes;
        @Nullable
        private List<ResourceHandle> resourceHandles;
        @Nullable
        private Boolean shareable;

        public Builder() {
        }

        public Builder(AllocationResult defaults) {
            Objects.requireNonNull(defaults);
            this.availableOnNodes = defaults.availableOnNodes;
            this.resourceHandles = defaults.resourceHandles;
            this.shareable = defaults.shareable;
        }

        @CustomType.Setter
        public Builder availableOnNodes(@Nullable NodeSelector availableOnNodes) {
            this.availableOnNodes = availableOnNodes;
            return this;
        }

        @CustomType.Setter
        public Builder resourceHandles(@Nullable List<ResourceHandle> resourceHandles) {
            this.resourceHandles = resourceHandles;
            return this;
        }

        public Builder resourceHandles(ResourceHandle ... resourceHandles) {
            return this.resourceHandles(List.of(resourceHandles));
        }

        @CustomType.Setter
        public Builder shareable(@Nullable Boolean shareable) {
            this.shareable = shareable;
            return this;
        }

        public AllocationResult build() {
            AllocationResult _resultValue = new AllocationResult();
            _resultValue.availableOnNodes = this.availableOnNodes;
            _resultValue.resourceHandles = this.resourceHandles;
            _resultValue.shareable = this.shareable;
            return _resultValue;
        }
    }
}

