/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.DriverRequests;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.ResourceClaimParametersReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceClaimParameters {
    @Nullable
    private String apiVersion;
    @Nullable
    private List<DriverRequests> driverRequests;
    @Nullable
    private ResourceClaimParametersReference generatedFrom;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private Boolean shareable;

    private ResourceClaimParameters() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public List<DriverRequests> driverRequests() {
        return this.driverRequests == null ? List.of() : this.driverRequests;
    }

    public Optional<ResourceClaimParametersReference> generatedFrom() {
        return Optional.ofNullable(this.generatedFrom);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<Boolean> shareable() {
        return Optional.ofNullable(this.shareable);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceClaimParameters defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private List<DriverRequests> driverRequests;
        @Nullable
        private ResourceClaimParametersReference generatedFrom;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private Boolean shareable;

        public Builder() {
        }

        public Builder(ResourceClaimParameters defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.driverRequests = defaults.driverRequests;
            this.generatedFrom = defaults.generatedFrom;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.shareable = defaults.shareable;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder driverRequests(@Nullable List<DriverRequests> driverRequests) {
            this.driverRequests = driverRequests;
            return this;
        }

        public Builder driverRequests(DriverRequests ... driverRequests) {
            return this.driverRequests(List.of(driverRequests));
        }

        @CustomType.Setter
        public Builder generatedFrom(@Nullable ResourceClaimParametersReference generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder shareable(@Nullable Boolean shareable) {
            this.shareable = shareable;
            return this;
        }

        public ResourceClaimParameters build() {
            ResourceClaimParameters _resultValue = new ResourceClaimParameters();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.driverRequests = this.driverRequests;
            _resultValue.generatedFrom = this.generatedFrom;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.shareable = this.shareable;
            return _resultValue;
        }
    }
}

