/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.ResourceClaimParametersReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceClaimSpec {
    @Nullable
    private String allocationMode;
    @Nullable
    private ResourceClaimParametersReference parametersRef;
    private String resourceClassName;

    private ResourceClaimSpec() {
    }

    public Optional<String> allocationMode() {
        return Optional.ofNullable(this.allocationMode);
    }

    public Optional<ResourceClaimParametersReference> parametersRef() {
        return Optional.ofNullable(this.parametersRef);
    }

    public String resourceClassName() {
        return this.resourceClassName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceClaimSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String allocationMode;
        @Nullable
        private ResourceClaimParametersReference parametersRef;
        private String resourceClassName;

        public Builder() {
        }

        public Builder(ResourceClaimSpec defaults) {
            Objects.requireNonNull(defaults);
            this.allocationMode = defaults.allocationMode;
            this.parametersRef = defaults.parametersRef;
            this.resourceClassName = defaults.resourceClassName;
        }

        @CustomType.Setter
        public Builder allocationMode(@Nullable String allocationMode) {
            this.allocationMode = allocationMode;
            return this;
        }

        @CustomType.Setter
        public Builder parametersRef(@Nullable ResourceClaimParametersReference parametersRef) {
            this.parametersRef = parametersRef;
            return this;
        }

        @CustomType.Setter
        public Builder resourceClassName(String resourceClassName) {
            if (resourceClassName == null) {
                throw new MissingRequiredPropertyException("ResourceClaimSpec", "resourceClassName");
            }
            this.resourceClassName = resourceClassName;
            return this;
        }

        public ResourceClaimSpec build() {
            ResourceClaimSpec _resultValue = new ResourceClaimSpec();
            _resultValue.allocationMode = this.allocationMode;
            _resultValue.parametersRef = this.parametersRef;
            _resultValue.resourceClassName = this.resourceClassName;
            return _resultValue;
        }
    }
}

