/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.ResourceClassParametersReference;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.ResourceFilter;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.VendorParameters;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceClassParameters {
    @Nullable
    private String apiVersion;
    @Nullable
    private List<ResourceFilter> filters;
    @Nullable
    private ResourceClassParametersReference generatedFrom;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private List<VendorParameters> vendorParameters;

    private ResourceClassParameters() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public List<ResourceFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public Optional<ResourceClassParametersReference> generatedFrom() {
        return Optional.ofNullable(this.generatedFrom);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public List<VendorParameters> vendorParameters() {
        return this.vendorParameters == null ? List.of() : this.vendorParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceClassParameters defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private List<ResourceFilter> filters;
        @Nullable
        private ResourceClassParametersReference generatedFrom;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private List<VendorParameters> vendorParameters;

        public Builder() {
        }

        public Builder(ResourceClassParameters defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.filters = defaults.filters;
            this.generatedFrom = defaults.generatedFrom;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.vendorParameters = defaults.vendorParameters;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<ResourceFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(ResourceFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder generatedFrom(@Nullable ResourceClassParametersReference generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder vendorParameters(@Nullable List<VendorParameters> vendorParameters) {
            this.vendorParameters = vendorParameters;
            return this;
        }

        public Builder vendorParameters(VendorParameters ... vendorParameters) {
            return this.vendorParameters(List.of(vendorParameters));
        }

        public ResourceClassParameters build() {
            ResourceClassParameters _resultValue = new ResourceClassParameters();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.filters = this.filters;
            _resultValue.generatedFrom = this.generatedFrom;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.vendorParameters = this.vendorParameters;
            return _resultValue;
        }
    }
}

