/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.resource.v1alpha2.outputs.NamedResourcesResources;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceSlice {
    @Nullable
    private String apiVersion;
    private String driverName;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private NamedResourcesResources namedResources;
    @Nullable
    private String nodeName;

    private ResourceSlice() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public String driverName() {
        return this.driverName;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<NamedResourcesResources> namedResources() {
        return Optional.ofNullable(this.namedResources);
    }

    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceSlice defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        private String driverName;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private NamedResourcesResources namedResources;
        @Nullable
        private String nodeName;

        public Builder() {
        }

        public Builder(ResourceSlice defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.driverName = defaults.driverName;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.namedResources = defaults.namedResources;
            this.nodeName = defaults.nodeName;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder driverName(String driverName) {
            if (driverName == null) {
                throw new MissingRequiredPropertyException("ResourceSlice", "driverName");
            }
            this.driverName = driverName;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder namedResources(@Nullable NamedResourcesResources namedResources) {
            this.namedResources = namedResources;
            return this;
        }

        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public ResourceSlice build() {
            ResourceSlice _resultValue = new ResourceSlice();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.driverName = this.driverName;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.namedResources = this.namedResources;
            _resultValue.nodeName = this.nodeName;
            return _resultValue;
        }
    }
}

