/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha3.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.resource.v1alpha3.outputs.OpaqueDeviceConfiguration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DeviceAllocationConfiguration {
    @Nullable
    private OpaqueDeviceConfiguration opaque;
    @Nullable
    private List<String> requests;
    private String source;

    private DeviceAllocationConfiguration() {
    }

    public Optional<OpaqueDeviceConfiguration> opaque() {
        return Optional.ofNullable(this.opaque);
    }

    public List<String> requests() {
        return this.requests == null ? List.of() : this.requests;
    }

    public String source() {
        return this.source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeviceAllocationConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private OpaqueDeviceConfiguration opaque;
        @Nullable
        private List<String> requests;
        private String source;

        public Builder() {
        }

        public Builder(DeviceAllocationConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.opaque = defaults.opaque;
            this.requests = defaults.requests;
            this.source = defaults.source;
        }

        @CustomType.Setter
        public Builder opaque(@Nullable OpaqueDeviceConfiguration opaque) {
            this.opaque = opaque;
            return this;
        }

        @CustomType.Setter
        public Builder requests(@Nullable List<String> requests) {
            this.requests = requests;
            return this;
        }

        public Builder requests(String ... requests) {
            return this.requests(List.of(requests));
        }

        @CustomType.Setter
        public Builder source(String source) {
            if (source == null) {
                throw new MissingRequiredPropertyException("DeviceAllocationConfiguration", "source");
            }
            this.source = source;
            return this;
        }

        public DeviceAllocationConfiguration build() {
            DeviceAllocationConfiguration _resultValue = new DeviceAllocationConfiguration();
            _resultValue.opaque = this.opaque;
            _resultValue.requests = this.requests;
            _resultValue.source = this.source;
            return _resultValue;
        }
    }
}

