/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha3.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.resource.v1alpha3.outputs.DeviceSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DeviceRequest {
    @Nullable
    private Boolean adminAccess;
    @Nullable
    private String allocationMode;
    @Nullable
    private Integer count;
    private String deviceClassName;
    private String name;
    @Nullable
    private List<DeviceSelector> selectors;

    private DeviceRequest() {
    }

    public Optional<Boolean> adminAccess() {
        return Optional.ofNullable(this.adminAccess);
    }

    public Optional<String> allocationMode() {
        return Optional.ofNullable(this.allocationMode);
    }

    public Optional<Integer> count() {
        return Optional.ofNullable(this.count);
    }

    public String deviceClassName() {
        return this.deviceClassName;
    }

    public String name() {
        return this.name;
    }

    public List<DeviceSelector> selectors() {
        return this.selectors == null ? List.of() : this.selectors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeviceRequest defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean adminAccess;
        @Nullable
        private String allocationMode;
        @Nullable
        private Integer count;
        private String deviceClassName;
        private String name;
        @Nullable
        private List<DeviceSelector> selectors;

        public Builder() {
        }

        public Builder(DeviceRequest defaults) {
            Objects.requireNonNull(defaults);
            this.adminAccess = defaults.adminAccess;
            this.allocationMode = defaults.allocationMode;
            this.count = defaults.count;
            this.deviceClassName = defaults.deviceClassName;
            this.name = defaults.name;
            this.selectors = defaults.selectors;
        }

        @CustomType.Setter
        public Builder adminAccess(@Nullable Boolean adminAccess) {
            this.adminAccess = adminAccess;
            return this;
        }

        @CustomType.Setter
        public Builder allocationMode(@Nullable String allocationMode) {
            this.allocationMode = allocationMode;
            return this;
        }

        @CustomType.Setter
        public Builder count(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        @CustomType.Setter
        public Builder deviceClassName(String deviceClassName) {
            if (deviceClassName == null) {
                throw new MissingRequiredPropertyException("DeviceRequest", "deviceClassName");
            }
            this.deviceClassName = deviceClassName;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("DeviceRequest", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder selectors(@Nullable List<DeviceSelector> selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder selectors(DeviceSelector ... selectors) {
            return this.selectors(List.of(selectors));
        }

        public DeviceRequest build() {
            DeviceRequest _resultValue = new DeviceRequest();
            _resultValue.adminAccess = this.adminAccess;
            _resultValue.allocationMode = this.allocationMode;
            _resultValue.count = this.count;
            _resultValue.deviceClassName = this.deviceClassName;
            _resultValue.name = this.name;
            _resultValue.selectors = this.selectors;
            return _resultValue;
        }
    }
}

