/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.resource.v1alpha3.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.NodeSelector;
import com.pulumi.kubernetes.resource.v1alpha3.outputs.Device;
import com.pulumi.kubernetes.resource.v1alpha3.outputs.ResourcePool;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceSliceSpec {
    @Nullable
    private Boolean allNodes;
    @Nullable
    private List<Device> devices;
    private String driver;
    @Nullable
    private String nodeName;
    @Nullable
    private NodeSelector nodeSelector;
    private ResourcePool pool;

    private ResourceSliceSpec() {
    }

    public Optional<Boolean> allNodes() {
        return Optional.ofNullable(this.allNodes);
    }

    public List<Device> devices() {
        return this.devices == null ? List.of() : this.devices;
    }

    public String driver() {
        return this.driver;
    }

    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public Optional<NodeSelector> nodeSelector() {
        return Optional.ofNullable(this.nodeSelector);
    }

    public ResourcePool pool() {
        return this.pool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceSliceSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean allNodes;
        @Nullable
        private List<Device> devices;
        private String driver;
        @Nullable
        private String nodeName;
        @Nullable
        private NodeSelector nodeSelector;
        private ResourcePool pool;

        public Builder() {
        }

        public Builder(ResourceSliceSpec defaults) {
            Objects.requireNonNull(defaults);
            this.allNodes = defaults.allNodes;
            this.devices = defaults.devices;
            this.driver = defaults.driver;
            this.nodeName = defaults.nodeName;
            this.nodeSelector = defaults.nodeSelector;
            this.pool = defaults.pool;
        }

        @CustomType.Setter
        public Builder allNodes(@Nullable Boolean allNodes) {
            this.allNodes = allNodes;
            return this;
        }

        @CustomType.Setter
        public Builder devices(@Nullable List<Device> devices) {
            this.devices = devices;
            return this;
        }

        public Builder devices(Device ... devices) {
            return this.devices(List.of(devices));
        }

        @CustomType.Setter
        public Builder driver(String driver) {
            if (driver == null) {
                throw new MissingRequiredPropertyException("ResourceSliceSpec", "driver");
            }
            this.driver = driver;
            return this;
        }

        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @CustomType.Setter
        public Builder nodeSelector(@Nullable NodeSelector nodeSelector) {
            this.nodeSelector = nodeSelector;
            return this;
        }

        @CustomType.Setter
        public Builder pool(ResourcePool pool) {
            if (pool == null) {
                throw new MissingRequiredPropertyException("ResourceSliceSpec", "pool");
            }
            this.pool = pool;
            return this;
        }

        public ResourceSliceSpec build() {
            ResourceSliceSpec _resultValue = new ResourceSliceSpec();
            _resultValue.allNodes = this.allNodes;
            _resultValue.devices = this.devices;
            _resultValue.driver = this.driver;
            _resultValue.nodeName = this.nodeName;
            _resultValue.nodeSelector = this.nodeSelector;
            _resultValue.pool = this.pool;
            return _resultValue;
        }
    }
}

