/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.storage.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.kubernetes.storage.v1.outputs.VolumeAttachmentSpec;
import com.pulumi.kubernetes.storage.v1.outputs.VolumeAttachmentStatus;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VolumeAttachment {
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    private VolumeAttachmentSpec spec;
    @Nullable
    private VolumeAttachmentStatus status;

    private VolumeAttachment() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public VolumeAttachmentSpec spec() {
        return this.spec;
    }

    public Optional<VolumeAttachmentStatus> status() {
        return Optional.ofNullable(this.status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VolumeAttachment defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        private VolumeAttachmentSpec spec;
        @Nullable
        private VolumeAttachmentStatus status;

        public Builder() {
        }

        public Builder(VolumeAttachment defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.spec = defaults.spec;
            this.status = defaults.status;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder spec(VolumeAttachmentSpec spec) {
            if (spec == null) {
                throw new MissingRequiredPropertyException("VolumeAttachment", "spec");
            }
            this.spec = spec;
            return this;
        }

        @CustomType.Setter
        public Builder status(@Nullable VolumeAttachmentStatus status) {
            this.status = status;
            return this;
        }

        public VolumeAttachment build() {
            VolumeAttachment _resultValue = new VolumeAttachment();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.spec = this.spec;
            _resultValue.status = this.status;
            return _resultValue;
        }
    }
}

