/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.storage.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VolumeAttributesClass {
    @Nullable
    private String apiVersion;
    private String driverName;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private Map<String, String> parameters;

    private VolumeAttributesClass() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public String driverName() {
        return this.driverName;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Map<String, String> parameters() {
        return this.parameters == null ? Map.of() : this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VolumeAttributesClass defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        private String driverName;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private Map<String, String> parameters;

        public Builder() {
        }

        public Builder(VolumeAttributesClass defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.driverName = defaults.driverName;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.parameters = defaults.parameters;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder driverName(String driverName) {
            if (driverName == null) {
                throw new MissingRequiredPropertyException("VolumeAttributesClass", "driverName");
            }
            this.driverName = driverName;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder parameters(@Nullable Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public VolumeAttributesClass build() {
            VolumeAttributesClass _resultValue = new VolumeAttributesClass();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.driverName = this.driverName;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.parameters = this.parameters;
            return _resultValue;
        }
    }
}

