/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.storage.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.storage.v1beta1.outputs.VolumeNodeResources;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CSINodeDriver {
    @Nullable
    private VolumeNodeResources allocatable;
    private String name;
    private String nodeID;
    @Nullable
    private List<String> topologyKeys;

    private CSINodeDriver() {
    }

    public Optional<VolumeNodeResources> allocatable() {
        return Optional.ofNullable(this.allocatable);
    }

    public String name() {
        return this.name;
    }

    public String nodeID() {
        return this.nodeID;
    }

    public List<String> topologyKeys() {
        return this.topologyKeys == null ? List.of() : this.topologyKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CSINodeDriver defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private VolumeNodeResources allocatable;
        private String name;
        private String nodeID;
        @Nullable
        private List<String> topologyKeys;

        public Builder() {
        }

        public Builder(CSINodeDriver defaults) {
            Objects.requireNonNull(defaults);
            this.allocatable = defaults.allocatable;
            this.name = defaults.name;
            this.nodeID = defaults.nodeID;
            this.topologyKeys = defaults.topologyKeys;
        }

        @CustomType.Setter
        public Builder allocatable(@Nullable VolumeNodeResources allocatable) {
            this.allocatable = allocatable;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("CSINodeDriver", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder nodeID(String nodeID) {
            if (nodeID == null) {
                throw new MissingRequiredPropertyException("CSINodeDriver", "nodeID");
            }
            this.nodeID = nodeID;
            return this;
        }

        @CustomType.Setter
        public Builder topologyKeys(@Nullable List<String> topologyKeys) {
            this.topologyKeys = topologyKeys;
            return this;
        }

        public Builder topologyKeys(String ... topologyKeys) {
            return this.topologyKeys(List.of(topologyKeys));
        }

        public CSINodeDriver build() {
            CSINodeDriver _resultValue = new CSINodeDriver();
            _resultValue.allocatable = this.allocatable;
            _resultValue.name = this.name;
            _resultValue.nodeID = this.nodeID;
            _resultValue.topologyKeys = this.topologyKeys;
            return _resultValue;
        }
    }
}

