/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.storage.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CSIStorageCapacity {
    @Nullable
    private String apiVersion;
    @Nullable
    private String capacity;
    @Nullable
    private String kind;
    @Nullable
    private String maximumVolumeSize;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private LabelSelector nodeTopology;
    private String storageClassName;

    private CSIStorageCapacity() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> capacity() {
        return Optional.ofNullable(this.capacity);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<String> maximumVolumeSize() {
        return Optional.ofNullable(this.maximumVolumeSize);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<LabelSelector> nodeTopology() {
        return Optional.ofNullable(this.nodeTopology);
    }

    public String storageClassName() {
        return this.storageClassName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CSIStorageCapacity defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String capacity;
        @Nullable
        private String kind;
        @Nullable
        private String maximumVolumeSize;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private LabelSelector nodeTopology;
        private String storageClassName;

        public Builder() {
        }

        public Builder(CSIStorageCapacity defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.capacity = defaults.capacity;
            this.kind = defaults.kind;
            this.maximumVolumeSize = defaults.maximumVolumeSize;
            this.metadata = defaults.metadata;
            this.nodeTopology = defaults.nodeTopology;
            this.storageClassName = defaults.storageClassName;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder capacity(@Nullable String capacity) {
            this.capacity = capacity;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder maximumVolumeSize(@Nullable String maximumVolumeSize) {
            this.maximumVolumeSize = maximumVolumeSize;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder nodeTopology(@Nullable LabelSelector nodeTopology) {
            this.nodeTopology = nodeTopology;
            return this;
        }

        @CustomType.Setter
        public Builder storageClassName(String storageClassName) {
            if (storageClassName == null) {
                throw new MissingRequiredPropertyException("CSIStorageCapacity", "storageClassName");
            }
            this.storageClassName = storageClassName;
            return this;
        }

        public CSIStorageCapacity build() {
            CSIStorageCapacity _resultValue = new CSIStorageCapacity();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.capacity = this.capacity;
            _resultValue.kind = this.kind;
            _resultValue.maximumVolumeSize = this.maximumVolumeSize;
            _resultValue.metadata = this.metadata;
            _resultValue.nodeTopology = this.nodeTopology;
            _resultValue.storageClassName = this.storageClassName;
            return _resultValue;
        }
    }
}

