/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.storage.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.TopologySelectorTerm;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StorageClass {
    @Nullable
    private Boolean allowVolumeExpansion;
    @Nullable
    private List<TopologySelectorTerm> allowedTopologies;
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private List<String> mountOptions;
    @Nullable
    private Map<String, String> parameters;
    private String provisioner;
    @Nullable
    private String reclaimPolicy;
    @Nullable
    private String volumeBindingMode;

    private StorageClass() {
    }

    public Optional<Boolean> allowVolumeExpansion() {
        return Optional.ofNullable(this.allowVolumeExpansion);
    }

    public List<TopologySelectorTerm> allowedTopologies() {
        return this.allowedTopologies == null ? List.of() : this.allowedTopologies;
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public List<String> mountOptions() {
        return this.mountOptions == null ? List.of() : this.mountOptions;
    }

    public Map<String, String> parameters() {
        return this.parameters == null ? Map.of() : this.parameters;
    }

    public String provisioner() {
        return this.provisioner;
    }

    public Optional<String> reclaimPolicy() {
        return Optional.ofNullable(this.reclaimPolicy);
    }

    public Optional<String> volumeBindingMode() {
        return Optional.ofNullable(this.volumeBindingMode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StorageClass defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean allowVolumeExpansion;
        @Nullable
        private List<TopologySelectorTerm> allowedTopologies;
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private List<String> mountOptions;
        @Nullable
        private Map<String, String> parameters;
        private String provisioner;
        @Nullable
        private String reclaimPolicy;
        @Nullable
        private String volumeBindingMode;

        public Builder() {
        }

        public Builder(StorageClass defaults) {
            Objects.requireNonNull(defaults);
            this.allowVolumeExpansion = defaults.allowVolumeExpansion;
            this.allowedTopologies = defaults.allowedTopologies;
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.mountOptions = defaults.mountOptions;
            this.parameters = defaults.parameters;
            this.provisioner = defaults.provisioner;
            this.reclaimPolicy = defaults.reclaimPolicy;
            this.volumeBindingMode = defaults.volumeBindingMode;
        }

        @CustomType.Setter
        public Builder allowVolumeExpansion(@Nullable Boolean allowVolumeExpansion) {
            this.allowVolumeExpansion = allowVolumeExpansion;
            return this;
        }

        @CustomType.Setter
        public Builder allowedTopologies(@Nullable List<TopologySelectorTerm> allowedTopologies) {
            this.allowedTopologies = allowedTopologies;
            return this;
        }

        public Builder allowedTopologies(TopologySelectorTerm ... allowedTopologies) {
            return this.allowedTopologies(List.of(allowedTopologies));
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder mountOptions(@Nullable List<String> mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public Builder mountOptions(String ... mountOptions) {
            return this.mountOptions(List.of(mountOptions));
        }

        @CustomType.Setter
        public Builder parameters(@Nullable Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @CustomType.Setter
        public Builder provisioner(String provisioner) {
            if (provisioner == null) {
                throw new MissingRequiredPropertyException("StorageClass", "provisioner");
            }
            this.provisioner = provisioner;
            return this;
        }

        @CustomType.Setter
        public Builder reclaimPolicy(@Nullable String reclaimPolicy) {
            this.reclaimPolicy = reclaimPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder volumeBindingMode(@Nullable String volumeBindingMode) {
            this.volumeBindingMode = volumeBindingMode;
            return this;
        }

        public StorageClass build() {
            StorageClass _resultValue = new StorageClass();
            _resultValue.allowVolumeExpansion = this.allowVolumeExpansion;
            _resultValue.allowedTopologies = this.allowedTopologies;
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.mountOptions = this.mountOptions;
            _resultValue.parameters = this.parameters;
            _resultValue.provisioner = this.provisioner;
            _resultValue.reclaimPolicy = this.reclaimPolicy;
            _resultValue.volumeBindingMode = this.volumeBindingMode;
            return _resultValue;
        }
    }
}

