// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.admissionregistration.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.meta.v1.inputs.LabelSelectorArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.
 * 
 */
public final class ParamRefArgs extends com.pulumi.resources.ResourceArgs {

    public static final ParamRefArgs Empty = new ParamRefArgs();

    /**
     * name is the name of the resource being referenced.
     * 
     * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
     * 
     * A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return name is the name of the resource being referenced.
     * 
     * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
     * 
     * A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
     * 
     * A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
     * 
     * - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
     * 
     * - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
     * 
     */
    @Import(name="namespace")
    private @Nullable Output<String> namespace;

    /**
     * @return namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
     * 
     * A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
     * 
     * - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
     * 
     * - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
     * 
     */
    public Optional<Output<String>> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    /**
     * `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
     * 
     * Allowed values are `Allow` or `Deny`
     * 
     * Required
     * 
     */
    @Import(name="parameterNotFoundAction")
    private @Nullable Output<String> parameterNotFoundAction;

    /**
     * @return `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
     * 
     * Allowed values are `Allow` or `Deny`
     * 
     * Required
     * 
     */
    public Optional<Output<String>> parameterNotFoundAction() {
        return Optional.ofNullable(this.parameterNotFoundAction);
    }

    /**
     * selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
     * 
     * If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
     * 
     * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
     * 
     */
    @Import(name="selector")
    private @Nullable Output<LabelSelectorArgs> selector;

    /**
     * @return selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
     * 
     * If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
     * 
     * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
     * 
     */
    public Optional<Output<LabelSelectorArgs>> selector() {
        return Optional.ofNullable(this.selector);
    }

    private ParamRefArgs() {}

    private ParamRefArgs(ParamRefArgs $) {
        this.name = $.name;
        this.namespace = $.namespace;
        this.parameterNotFoundAction = $.parameterNotFoundAction;
        this.selector = $.selector;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ParamRefArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ParamRefArgs $;

        public Builder() {
            $ = new ParamRefArgs();
        }

        public Builder(ParamRefArgs defaults) {
            $ = new ParamRefArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name name is the name of the resource being referenced.
         * 
         * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
         * 
         * A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name name is the name of the resource being referenced.
         * 
         * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
         * 
         * A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param namespace namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
         * 
         * A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
         * 
         * - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
         * 
         * - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
         * 
         * @return builder
         * 
         */
        public Builder namespace(@Nullable Output<String> namespace) {
            $.namespace = namespace;
            return this;
        }

        /**
         * @param namespace namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.
         * 
         * A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.
         * 
         * - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.
         * 
         * - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.
         * 
         * @return builder
         * 
         */
        public Builder namespace(String namespace) {
            return namespace(Output.of(namespace));
        }

        /**
         * @param parameterNotFoundAction `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
         * 
         * Allowed values are `Allow` or `Deny`
         * 
         * Required
         * 
         * @return builder
         * 
         */
        public Builder parameterNotFoundAction(@Nullable Output<String> parameterNotFoundAction) {
            $.parameterNotFoundAction = parameterNotFoundAction;
            return this;
        }

        /**
         * @param parameterNotFoundAction `parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.
         * 
         * Allowed values are `Allow` or `Deny`
         * 
         * Required
         * 
         * @return builder
         * 
         */
        public Builder parameterNotFoundAction(String parameterNotFoundAction) {
            return parameterNotFoundAction(Output.of(parameterNotFoundAction));
        }

        /**
         * @param selector selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
         * 
         * If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
         * 
         * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
         * 
         * @return builder
         * 
         */
        public Builder selector(@Nullable Output<LabelSelectorArgs> selector) {
            $.selector = selector;
            return this;
        }

        /**
         * @param selector selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.
         * 
         * If multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.
         * 
         * One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.
         * 
         * @return builder
         * 
         */
        public Builder selector(LabelSelectorArgs selector) {
            return selector(Output.of(selector));
        }

        public ParamRefArgs build() {
            return $;
        }
    }

}
