// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.apiextensions;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

import javax.annotation.Nullable;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.core.internal.Internal;
import com.pulumi.core.internal.OutputInternal;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.resources.ResourceArgs;

/**
 * CustomResource represents an instance of a CustomResourceDefinition (CRD). For example, the
 * CoreOS Prometheus operator exposes a CRD `monitoring.coreos.com/ServiceMonitor`; to
 * instantiate this as a Pulumi resource, one could call `new CustomResource`, passing the
 * `ServiceMonitor` resource definition as an argument.
 */
@ResourceType(type="kubernetes:apiextensions:CustomResource")
public class CustomResource extends com.pulumi.resources.CustomResource {
    /**
     * APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output<String> apiVersion;

    /**
     * @return APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    public Output<String> apiVersion() {
        return this.apiVersion;
    }

    /**
     * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output<String> kind;

    /**
     * @return Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    public Output<String> kind() {
        return this.kind;
    }

    /**
     * Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    @Export(name="metadata", refs={ObjectMeta.class}, tree="[0]")
    private Output<ObjectMeta> metadata;

    /**
     * @return Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    public Output<ObjectMeta> metadata() {
        return this.metadata;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CustomResource(String name) {
        this(name, CustomResourceArgs.Empty);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CustomResource(String name, CustomResourceArgsBase args) {
        this(name, args, null);
    }
    
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CustomResource(String name, CustomResourceArgsBase args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super(makeType(args), name, makeArgs(args), makeResourceOptions(options, Codegen.empty()));
    }

    protected CustomResource(String name, String apiVersion, String kind, Output<String> id, 
            @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super(String.format("kubernetes:%s:%s", apiVersion, kind), name, null, makeResourceOptions(options, id));
    }

    private static String makeType(CustomResourceArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        String apiVersion = args.apiVersion().map(Internal::of).map(CustomResource::getOutputValue).orElse("");
        String kind = args.kind().map(Internal::of).map(CustomResource::getOutputValue).orElse("");
        return String.format("kubernetes:%s:%s", apiVersion, kind);
    }

    private static String getOutputValue(OutputInternal<String> o) {
        try {
            return o.getValueOrDefault("").get();
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResourceArgs makeArgs(CustomResourceArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        if (args.otherFields().isEmpty() || args.otherFields().get().isEmpty()) {
            // optimization: if there are no "other" fields, we can just return the args as-is.
            // Otherwise we generate a subclass of ResourceArgs that includes the "other" fields.
            return args;
        }
        return Util.generateResourceArgs(args, args.otherFields().get());
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(
            @Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
                .version(Utilities.getVersion())
                .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get the state of an existing `CustomResource` resource, as identified by `id`.
     * Typically this ID is of the form [namespace]/[name]; if [namespace] is omitted,
     * then (per Kubernetes convention) the ID becomes default/[name].
     *
     * @param name The _unique_ name of the resulting resource.
     * @param apiVersion The API version of the CustomResource we wish to select, as defined by the CRD.
     * @param kind The kind of the CustomResource we wish to select, as defined by the CRD.
     * @param id An ID for the Kubernetes resource to retrieve.
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CustomResource get(String name, String apiVersion, String kind, Output<String> id, 
            @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CustomResource(name, apiVersion, kind, id, options);
    }
}
