// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.apiextensions;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

import javax.annotation.Nullable;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.core.internal.Internal;
import com.pulumi.core.internal.OutputInternal;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMetaPatch;
import com.pulumi.resources.ResourceArgs;

/**
 * Patch resources are used to modify existing Kubernetes resources by using
 * Server-Side Apply updates. The name of the resource must be specified, but all other properties are optional. More than
 * one patch may be applied to the same resource, and a random FieldManager name will be used for each Patch resource.
 * Conflicts will result in an error by default, but can be forced using the &#34;pulumi.com/patchForce&#34; annotation. See the
 * [Server-Side Apply Docs](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/managing-resources-with-server-side-apply/) for
 * additional information about using Server-Side Apply to manage Kubernetes resources with Pulumi.
 * 
 * CustomResourcePatch represents an instance of a CustomResourceDefinition (CRD). For example, the
 * CoreOS Prometheus operator exposes a CRD `monitoring.coreos.com/ServiceMonitor`; to
 * instantiate this as a Pulumi resource, one could call `new CustomResourcePatch`, passing the
 * `ServiceMonitor` resource definition as an argument.
 */
@ResourceType(type="kubernetes:apiextensions:CustomResourcePatch")
public class CustomResourcePatch extends com.pulumi.resources.CustomResource {
    /**
     * APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> apiVersion;

    /**
     * @return APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    public Output<Optional<String>> apiVersion() {
        return Codegen.optional(this.apiVersion);
    }

    /**
     * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kind;

    /**
     * @return Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    public Output<Optional<String>> kind() {
        return Codegen.optional(this.kind);
    }
    /**
     * Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    @Export(name="metadata", refs={ObjectMetaPatch.class}, tree="[0]")
    private Output</* @Nullable */ ObjectMetaPatch> metadata;

    /**
     * @return Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    public Output<Optional<ObjectMetaPatch>> metadata() {
        return Codegen.optional(this.metadata);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CustomResourcePatch(String name) {
        this(name, CustomResourcePatchArgs.Empty);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CustomResourcePatch(String name, CustomResourcePatchArgsBase args) {
        this(name, args, null);
    }
    
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CustomResourcePatch(String name, CustomResourcePatchArgsBase args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super(makeType(args), name, makeArgs(args), makeResourceOptions(options, Codegen.empty()));
    }

    private static String makeType(CustomResourcePatchArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        String apiVersion = args.apiVersion().map(Internal::of).map(CustomResourcePatch::getOutputValue).orElse("");
        String kind = args.kind().map(Internal::of).map(CustomResourcePatch::getOutputValue).orElse("");
        return String.format("kubernetes:%s:%sPatch", apiVersion, kind);
    }

    private static String getOutputValue(OutputInternal<String> o) {
        try {
            return o.getValueOrDefault("").get();
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResourceArgs makeArgs(@Nullable CustomResourcePatchArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        if (args.otherFields().isEmpty() || args.otherFields().get().isEmpty()) {
            // optimization: if there are no "other" fields, we can just use the args as-is.
            // Otherwise we generate a subclass of ResourceArgs that includes the "other" fields.
            return args;
        }
        return Util.generateResourceArgs(args, args.otherFields().get());
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(
            @Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
                .version(Utilities.getVersion())
                .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }
}
