// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.apiextensions.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.apiextensions.v1.inputs.WebhookClientConfigArgs;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * WebhookConversion describes how to call a conversion webhook
 * 
 */
public final class WebhookConversionArgs extends com.pulumi.resources.ResourceArgs {

    public static final WebhookConversionArgs Empty = new WebhookConversionArgs();

    /**
     * clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
     * 
     */
    @Import(name="clientConfig")
    private @Nullable Output<WebhookClientConfigArgs> clientConfig;

    /**
     * @return clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
     * 
     */
    public Optional<Output<WebhookClientConfigArgs>> clientConfig() {
        return Optional.ofNullable(this.clientConfig);
    }

    /**
     * conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
     * 
     */
    @Import(name="conversionReviewVersions", required=true)
    private Output<List<String>> conversionReviewVersions;

    /**
     * @return conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
     * 
     */
    public Output<List<String>> conversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    private WebhookConversionArgs() {}

    private WebhookConversionArgs(WebhookConversionArgs $) {
        this.clientConfig = $.clientConfig;
        this.conversionReviewVersions = $.conversionReviewVersions;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(WebhookConversionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private WebhookConversionArgs $;

        public Builder() {
            $ = new WebhookConversionArgs();
        }

        public Builder(WebhookConversionArgs defaults) {
            $ = new WebhookConversionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param clientConfig clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
         * 
         * @return builder
         * 
         */
        public Builder clientConfig(@Nullable Output<WebhookClientConfigArgs> clientConfig) {
            $.clientConfig = clientConfig;
            return this;
        }

        /**
         * @param clientConfig clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
         * 
         * @return builder
         * 
         */
        public Builder clientConfig(WebhookClientConfigArgs clientConfig) {
            return clientConfig(Output.of(clientConfig));
        }

        /**
         * @param conversionReviewVersions conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
         * 
         * @return builder
         * 
         */
        public Builder conversionReviewVersions(Output<List<String>> conversionReviewVersions) {
            $.conversionReviewVersions = conversionReviewVersions;
            return this;
        }

        /**
         * @param conversionReviewVersions conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
         * 
         * @return builder
         * 
         */
        public Builder conversionReviewVersions(List<String> conversionReviewVersions) {
            return conversionReviewVersions(Output.of(conversionReviewVersions));
        }

        /**
         * @param conversionReviewVersions conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
         * 
         * @return builder
         * 
         */
        public Builder conversionReviewVersions(String... conversionReviewVersions) {
            return conversionReviewVersions(List.of(conversionReviewVersions));
        }

        public WebhookConversionArgs build() {
            if ($.conversionReviewVersions == null) {
                throw new MissingRequiredPropertyException("WebhookConversionArgs", "conversionReviewVersions");
            }
            return $;
        }
    }

}
