// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.apps.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.apps.v1.outputs.StatefulSetOrdinals;
import com.pulumi.kubernetes.apps.v1.outputs.StatefulSetPersistentVolumeClaimRetentionPolicy;
import com.pulumi.kubernetes.apps.v1.outputs.StatefulSetUpdateStrategy;
import com.pulumi.kubernetes.core.v1.outputs.PersistentVolumeClaim;
import com.pulumi.kubernetes.core.v1.outputs.PodTemplateSpec;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StatefulSetSpec {
    /**
     * @return Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
     * 
     */
    private @Nullable Integer minReadySeconds;
    /**
     * @return ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a &#34;0&#34; index to the first replica and increments the index by one for each additional replica requested.
     * 
     */
    private @Nullable StatefulSetOrdinals ordinals;
    /**
     * @return persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is beta.
     * 
     */
    private @Nullable StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy;
    /**
     * @return podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
     * 
     */
    private @Nullable String podManagementPolicy;
    /**
     * @return replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
     * 
     */
    private @Nullable Integer replicas;
    /**
     * @return revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet&#39;s revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
     * 
     */
    private @Nullable Integer revisionHistoryLimit;
    /**
     * @return selector is a label query over pods that should match the replica count. It must match the pod template&#39;s labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * 
     */
    private LabelSelector selector;
    /**
     * @return serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where &#34;pod-specific-string&#34; is managed by the StatefulSet controller.
     * 
     */
    private String serviceName;
    /**
     * @return template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format &lt;statefulsetname&gt;-&lt;podindex&gt;. For example, a pod in a StatefulSet named &#34;web&#34; with index number &#34;3&#34; would be named &#34;web-3&#34;. The only allowed template.spec.restartPolicy value is &#34;Always&#34;.
     * 
     */
    private PodTemplateSpec template;
    /**
     * @return updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
     * 
     */
    private @Nullable StatefulSetUpdateStrategy updateStrategy;
    /**
     * @return volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
     * 
     */
    private @Nullable List<PersistentVolumeClaim> volumeClaimTemplates;

    private StatefulSetSpec() {}
    /**
     * @return Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
     * 
     */
    public Optional<Integer> minReadySeconds() {
        return Optional.ofNullable(this.minReadySeconds);
    }
    /**
     * @return ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a &#34;0&#34; index to the first replica and increments the index by one for each additional replica requested.
     * 
     */
    public Optional<StatefulSetOrdinals> ordinals() {
        return Optional.ofNullable(this.ordinals);
    }
    /**
     * @return persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is beta.
     * 
     */
    public Optional<StatefulSetPersistentVolumeClaimRetentionPolicy> persistentVolumeClaimRetentionPolicy() {
        return Optional.ofNullable(this.persistentVolumeClaimRetentionPolicy);
    }
    /**
     * @return podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
     * 
     */
    public Optional<String> podManagementPolicy() {
        return Optional.ofNullable(this.podManagementPolicy);
    }
    /**
     * @return replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
     * 
     */
    public Optional<Integer> replicas() {
        return Optional.ofNullable(this.replicas);
    }
    /**
     * @return revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet&#39;s revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
     * 
     */
    public Optional<Integer> revisionHistoryLimit() {
        return Optional.ofNullable(this.revisionHistoryLimit);
    }
    /**
     * @return selector is a label query over pods that should match the replica count. It must match the pod template&#39;s labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * 
     */
    public LabelSelector selector() {
        return this.selector;
    }
    /**
     * @return serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where &#34;pod-specific-string&#34; is managed by the StatefulSet controller.
     * 
     */
    public String serviceName() {
        return this.serviceName;
    }
    /**
     * @return template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format &lt;statefulsetname&gt;-&lt;podindex&gt;. For example, a pod in a StatefulSet named &#34;web&#34; with index number &#34;3&#34; would be named &#34;web-3&#34;. The only allowed template.spec.restartPolicy value is &#34;Always&#34;.
     * 
     */
    public PodTemplateSpec template() {
        return this.template;
    }
    /**
     * @return updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
     * 
     */
    public Optional<StatefulSetUpdateStrategy> updateStrategy() {
        return Optional.ofNullable(this.updateStrategy);
    }
    /**
     * @return volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
     * 
     */
    public List<PersistentVolumeClaim> volumeClaimTemplates() {
        return this.volumeClaimTemplates == null ? List.of() : this.volumeClaimTemplates;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StatefulSetSpec defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Integer minReadySeconds;
        private @Nullable StatefulSetOrdinals ordinals;
        private @Nullable StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy;
        private @Nullable String podManagementPolicy;
        private @Nullable Integer replicas;
        private @Nullable Integer revisionHistoryLimit;
        private LabelSelector selector;
        private String serviceName;
        private PodTemplateSpec template;
        private @Nullable StatefulSetUpdateStrategy updateStrategy;
        private @Nullable List<PersistentVolumeClaim> volumeClaimTemplates;
        public Builder() {}
        public Builder(StatefulSetSpec defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.minReadySeconds = defaults.minReadySeconds;
    	      this.ordinals = defaults.ordinals;
    	      this.persistentVolumeClaimRetentionPolicy = defaults.persistentVolumeClaimRetentionPolicy;
    	      this.podManagementPolicy = defaults.podManagementPolicy;
    	      this.replicas = defaults.replicas;
    	      this.revisionHistoryLimit = defaults.revisionHistoryLimit;
    	      this.selector = defaults.selector;
    	      this.serviceName = defaults.serviceName;
    	      this.template = defaults.template;
    	      this.updateStrategy = defaults.updateStrategy;
    	      this.volumeClaimTemplates = defaults.volumeClaimTemplates;
        }

        @CustomType.Setter
        public Builder minReadySeconds(@Nullable Integer minReadySeconds) {

            this.minReadySeconds = minReadySeconds;
            return this;
        }
        @CustomType.Setter
        public Builder ordinals(@Nullable StatefulSetOrdinals ordinals) {

            this.ordinals = ordinals;
            return this;
        }
        @CustomType.Setter
        public Builder persistentVolumeClaimRetentionPolicy(@Nullable StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {

            this.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder podManagementPolicy(@Nullable String podManagementPolicy) {

            this.podManagementPolicy = podManagementPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder replicas(@Nullable Integer replicas) {

            this.replicas = replicas;
            return this;
        }
        @CustomType.Setter
        public Builder revisionHistoryLimit(@Nullable Integer revisionHistoryLimit) {

            this.revisionHistoryLimit = revisionHistoryLimit;
            return this;
        }
        @CustomType.Setter
        public Builder selector(LabelSelector selector) {
            if (selector == null) {
              throw new MissingRequiredPropertyException("StatefulSetSpec", "selector");
            }
            this.selector = selector;
            return this;
        }
        @CustomType.Setter
        public Builder serviceName(String serviceName) {
            if (serviceName == null) {
              throw new MissingRequiredPropertyException("StatefulSetSpec", "serviceName");
            }
            this.serviceName = serviceName;
            return this;
        }
        @CustomType.Setter
        public Builder template(PodTemplateSpec template) {
            if (template == null) {
              throw new MissingRequiredPropertyException("StatefulSetSpec", "template");
            }
            this.template = template;
            return this;
        }
        @CustomType.Setter
        public Builder updateStrategy(@Nullable StatefulSetUpdateStrategy updateStrategy) {

            this.updateStrategy = updateStrategy;
            return this;
        }
        @CustomType.Setter
        public Builder volumeClaimTemplates(@Nullable List<PersistentVolumeClaim> volumeClaimTemplates) {

            this.volumeClaimTemplates = volumeClaimTemplates;
            return this;
        }
        public Builder volumeClaimTemplates(PersistentVolumeClaim... volumeClaimTemplates) {
            return volumeClaimTemplates(List.of(volumeClaimTemplates));
        }
        public StatefulSetSpec build() {
            final var _resultValue = new StatefulSetSpec();
            _resultValue.minReadySeconds = minReadySeconds;
            _resultValue.ordinals = ordinals;
            _resultValue.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
            _resultValue.podManagementPolicy = podManagementPolicy;
            _resultValue.replicas = replicas;
            _resultValue.revisionHistoryLimit = revisionHistoryLimit;
            _resultValue.selector = selector;
            _resultValue.serviceName = serviceName;
            _resultValue.template = template;
            _resultValue.updateStrategy = updateStrategy;
            _resultValue.volumeClaimTemplates = volumeClaimTemplates;
            return _resultValue;
        }
    }
}
