// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.apps.v1beta2.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.apps.v1beta2.inputs.DaemonSetUpdateStrategyPatchArgs;
import com.pulumi.kubernetes.core.v1.inputs.PodTemplateSpecPatchArgs;
import com.pulumi.kubernetes.meta.v1.inputs.LabelSelectorPatchArgs;
import java.lang.Integer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * DaemonSetSpec is the specification of a daemon set.
 * 
 */
public final class DaemonSetSpecPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final DaemonSetSpecPatchArgs Empty = new DaemonSetSpecPatchArgs();

    /**
     * The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
     * 
     */
    @Import(name="minReadySeconds")
    private @Nullable Output<Integer> minReadySeconds;

    /**
     * @return The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
     * 
     */
    public Optional<Output<Integer>> minReadySeconds() {
        return Optional.ofNullable(this.minReadySeconds);
    }

    /**
     * The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
     * 
     */
    @Import(name="revisionHistoryLimit")
    private @Nullable Output<Integer> revisionHistoryLimit;

    /**
     * @return The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
     * 
     */
    public Optional<Output<Integer>> revisionHistoryLimit() {
        return Optional.ofNullable(this.revisionHistoryLimit);
    }

    /**
     * A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template&#39;s labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * 
     */
    @Import(name="selector")
    private @Nullable Output<LabelSelectorPatchArgs> selector;

    /**
     * @return A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template&#39;s labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * 
     */
    public Optional<Output<LabelSelectorPatchArgs>> selector() {
        return Optional.ofNullable(this.selector);
    }

    /**
     * An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template&#39;s node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * 
     */
    @Import(name="template")
    private @Nullable Output<PodTemplateSpecPatchArgs> template;

    /**
     * @return An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template&#39;s node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * 
     */
    public Optional<Output<PodTemplateSpecPatchArgs>> template() {
        return Optional.ofNullable(this.template);
    }

    /**
     * An update strategy to replace existing DaemonSet pods with new pods.
     * 
     */
    @Import(name="updateStrategy")
    private @Nullable Output<DaemonSetUpdateStrategyPatchArgs> updateStrategy;

    /**
     * @return An update strategy to replace existing DaemonSet pods with new pods.
     * 
     */
    public Optional<Output<DaemonSetUpdateStrategyPatchArgs>> updateStrategy() {
        return Optional.ofNullable(this.updateStrategy);
    }

    private DaemonSetSpecPatchArgs() {}

    private DaemonSetSpecPatchArgs(DaemonSetSpecPatchArgs $) {
        this.minReadySeconds = $.minReadySeconds;
        this.revisionHistoryLimit = $.revisionHistoryLimit;
        this.selector = $.selector;
        this.template = $.template;
        this.updateStrategy = $.updateStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DaemonSetSpecPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DaemonSetSpecPatchArgs $;

        public Builder() {
            $ = new DaemonSetSpecPatchArgs();
        }

        public Builder(DaemonSetSpecPatchArgs defaults) {
            $ = new DaemonSetSpecPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param minReadySeconds The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
         * 
         * @return builder
         * 
         */
        public Builder minReadySeconds(@Nullable Output<Integer> minReadySeconds) {
            $.minReadySeconds = minReadySeconds;
            return this;
        }

        /**
         * @param minReadySeconds The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
         * 
         * @return builder
         * 
         */
        public Builder minReadySeconds(Integer minReadySeconds) {
            return minReadySeconds(Output.of(minReadySeconds));
        }

        /**
         * @param revisionHistoryLimit The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
         * 
         * @return builder
         * 
         */
        public Builder revisionHistoryLimit(@Nullable Output<Integer> revisionHistoryLimit) {
            $.revisionHistoryLimit = revisionHistoryLimit;
            return this;
        }

        /**
         * @param revisionHistoryLimit The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
         * 
         * @return builder
         * 
         */
        public Builder revisionHistoryLimit(Integer revisionHistoryLimit) {
            return revisionHistoryLimit(Output.of(revisionHistoryLimit));
        }

        /**
         * @param selector A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template&#39;s labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
         * 
         * @return builder
         * 
         */
        public Builder selector(@Nullable Output<LabelSelectorPatchArgs> selector) {
            $.selector = selector;
            return this;
        }

        /**
         * @param selector A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template&#39;s labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
         * 
         * @return builder
         * 
         */
        public Builder selector(LabelSelectorPatchArgs selector) {
            return selector(Output.of(selector));
        }

        /**
         * @param template An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template&#39;s node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
         * 
         * @return builder
         * 
         */
        public Builder template(@Nullable Output<PodTemplateSpecPatchArgs> template) {
            $.template = template;
            return this;
        }

        /**
         * @param template An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template&#39;s node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
         * 
         * @return builder
         * 
         */
        public Builder template(PodTemplateSpecPatchArgs template) {
            return template(Output.of(template));
        }

        /**
         * @param updateStrategy An update strategy to replace existing DaemonSet pods with new pods.
         * 
         * @return builder
         * 
         */
        public Builder updateStrategy(@Nullable Output<DaemonSetUpdateStrategyPatchArgs> updateStrategy) {
            $.updateStrategy = updateStrategy;
            return this;
        }

        /**
         * @param updateStrategy An update strategy to replace existing DaemonSet pods with new pods.
         * 
         * @return builder
         * 
         */
        public Builder updateStrategy(DaemonSetUpdateStrategyPatchArgs updateStrategy) {
            return updateStrategy(Output.of(updateStrategy));
        }

        public DaemonSetSpecPatchArgs build() {
            return $;
        }
    }

}
