// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v1.inputs.CrossVersionObjectReferenceArgs;
import java.lang.Integer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * specification of a horizontal pod autoscaler.
 * 
 */
public final class HorizontalPodAutoscalerSpecArgs extends com.pulumi.resources.ResourceArgs {

    public static final HorizontalPodAutoscalerSpecArgs Empty = new HorizontalPodAutoscalerSpecArgs();

    /**
     * maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.
     * 
     */
    @Import(name="maxReplicas", required=true)
    private Output<Integer> maxReplicas;

    /**
     * @return maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.
     * 
     */
    public Output<Integer> maxReplicas() {
        return this.maxReplicas;
    }

    /**
     * minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     * 
     */
    @Import(name="minReplicas")
    private @Nullable Output<Integer> minReplicas;

    /**
     * @return minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     * 
     */
    public Optional<Output<Integer>> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    /**
     * reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
     * 
     */
    @Import(name="scaleTargetRef", required=true)
    private Output<CrossVersionObjectReferenceArgs> scaleTargetRef;

    /**
     * @return reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
     * 
     */
    public Output<CrossVersionObjectReferenceArgs> scaleTargetRef() {
        return this.scaleTargetRef;
    }

    /**
     * targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.
     * 
     */
    @Import(name="targetCPUUtilizationPercentage")
    private @Nullable Output<Integer> targetCPUUtilizationPercentage;

    /**
     * @return targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.
     * 
     */
    public Optional<Output<Integer>> targetCPUUtilizationPercentage() {
        return Optional.ofNullable(this.targetCPUUtilizationPercentage);
    }

    private HorizontalPodAutoscalerSpecArgs() {}

    private HorizontalPodAutoscalerSpecArgs(HorizontalPodAutoscalerSpecArgs $) {
        this.maxReplicas = $.maxReplicas;
        this.minReplicas = $.minReplicas;
        this.scaleTargetRef = $.scaleTargetRef;
        this.targetCPUUtilizationPercentage = $.targetCPUUtilizationPercentage;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(HorizontalPodAutoscalerSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HorizontalPodAutoscalerSpecArgs $;

        public Builder() {
            $ = new HorizontalPodAutoscalerSpecArgs();
        }

        public Builder(HorizontalPodAutoscalerSpecArgs defaults) {
            $ = new HorizontalPodAutoscalerSpecArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param maxReplicas maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.
         * 
         * @return builder
         * 
         */
        public Builder maxReplicas(Output<Integer> maxReplicas) {
            $.maxReplicas = maxReplicas;
            return this;
        }

        /**
         * @param maxReplicas maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.
         * 
         * @return builder
         * 
         */
        public Builder maxReplicas(Integer maxReplicas) {
            return maxReplicas(Output.of(maxReplicas));
        }

        /**
         * @param minReplicas minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
         * 
         * @return builder
         * 
         */
        public Builder minReplicas(@Nullable Output<Integer> minReplicas) {
            $.minReplicas = minReplicas;
            return this;
        }

        /**
         * @param minReplicas minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
         * 
         * @return builder
         * 
         */
        public Builder minReplicas(Integer minReplicas) {
            return minReplicas(Output.of(minReplicas));
        }

        /**
         * @param scaleTargetRef reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
         * 
         * @return builder
         * 
         */
        public Builder scaleTargetRef(Output<CrossVersionObjectReferenceArgs> scaleTargetRef) {
            $.scaleTargetRef = scaleTargetRef;
            return this;
        }

        /**
         * @param scaleTargetRef reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
         * 
         * @return builder
         * 
         */
        public Builder scaleTargetRef(CrossVersionObjectReferenceArgs scaleTargetRef) {
            return scaleTargetRef(Output.of(scaleTargetRef));
        }

        /**
         * @param targetCPUUtilizationPercentage targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.
         * 
         * @return builder
         * 
         */
        public Builder targetCPUUtilizationPercentage(@Nullable Output<Integer> targetCPUUtilizationPercentage) {
            $.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
            return this;
        }

        /**
         * @param targetCPUUtilizationPercentage targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.
         * 
         * @return builder
         * 
         */
        public Builder targetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
            return targetCPUUtilizationPercentage(Output.of(targetCPUUtilizationPercentage));
        }

        public HorizontalPodAutoscalerSpecArgs build() {
            if ($.maxReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpecArgs", "maxReplicas");
            }
            if ($.scaleTargetRef == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpecArgs", "scaleTargetRef");
            }
            return $;
        }
    }

}
