// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * current status of a horizontal pod autoscaler
 * 
 */
public final class HorizontalPodAutoscalerStatusArgs extends com.pulumi.resources.ResourceArgs {

    public static final HorizontalPodAutoscalerStatusArgs Empty = new HorizontalPodAutoscalerStatusArgs();

    /**
     * currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.
     * 
     */
    @Import(name="currentCPUUtilizationPercentage")
    private @Nullable Output<Integer> currentCPUUtilizationPercentage;

    /**
     * @return currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.
     * 
     */
    public Optional<Output<Integer>> currentCPUUtilizationPercentage() {
        return Optional.ofNullable(this.currentCPUUtilizationPercentage);
    }

    /**
     * currentReplicas is the current number of replicas of pods managed by this autoscaler.
     * 
     */
    @Import(name="currentReplicas", required=true)
    private Output<Integer> currentReplicas;

    /**
     * @return currentReplicas is the current number of replicas of pods managed by this autoscaler.
     * 
     */
    public Output<Integer> currentReplicas() {
        return this.currentReplicas;
    }

    /**
     * desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.
     * 
     */
    @Import(name="desiredReplicas", required=true)
    private Output<Integer> desiredReplicas;

    /**
     * @return desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.
     * 
     */
    public Output<Integer> desiredReplicas() {
        return this.desiredReplicas;
    }

    /**
     * lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.
     * 
     */
    @Import(name="lastScaleTime")
    private @Nullable Output<String> lastScaleTime;

    /**
     * @return lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.
     * 
     */
    public Optional<Output<String>> lastScaleTime() {
        return Optional.ofNullable(this.lastScaleTime);
    }

    /**
     * observedGeneration is the most recent generation observed by this autoscaler.
     * 
     */
    @Import(name="observedGeneration")
    private @Nullable Output<Integer> observedGeneration;

    /**
     * @return observedGeneration is the most recent generation observed by this autoscaler.
     * 
     */
    public Optional<Output<Integer>> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }

    private HorizontalPodAutoscalerStatusArgs() {}

    private HorizontalPodAutoscalerStatusArgs(HorizontalPodAutoscalerStatusArgs $) {
        this.currentCPUUtilizationPercentage = $.currentCPUUtilizationPercentage;
        this.currentReplicas = $.currentReplicas;
        this.desiredReplicas = $.desiredReplicas;
        this.lastScaleTime = $.lastScaleTime;
        this.observedGeneration = $.observedGeneration;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(HorizontalPodAutoscalerStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HorizontalPodAutoscalerStatusArgs $;

        public Builder() {
            $ = new HorizontalPodAutoscalerStatusArgs();
        }

        public Builder(HorizontalPodAutoscalerStatusArgs defaults) {
            $ = new HorizontalPodAutoscalerStatusArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param currentCPUUtilizationPercentage currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.
         * 
         * @return builder
         * 
         */
        public Builder currentCPUUtilizationPercentage(@Nullable Output<Integer> currentCPUUtilizationPercentage) {
            $.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
            return this;
        }

        /**
         * @param currentCPUUtilizationPercentage currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.
         * 
         * @return builder
         * 
         */
        public Builder currentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
            return currentCPUUtilizationPercentage(Output.of(currentCPUUtilizationPercentage));
        }

        /**
         * @param currentReplicas currentReplicas is the current number of replicas of pods managed by this autoscaler.
         * 
         * @return builder
         * 
         */
        public Builder currentReplicas(Output<Integer> currentReplicas) {
            $.currentReplicas = currentReplicas;
            return this;
        }

        /**
         * @param currentReplicas currentReplicas is the current number of replicas of pods managed by this autoscaler.
         * 
         * @return builder
         * 
         */
        public Builder currentReplicas(Integer currentReplicas) {
            return currentReplicas(Output.of(currentReplicas));
        }

        /**
         * @param desiredReplicas desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.
         * 
         * @return builder
         * 
         */
        public Builder desiredReplicas(Output<Integer> desiredReplicas) {
            $.desiredReplicas = desiredReplicas;
            return this;
        }

        /**
         * @param desiredReplicas desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.
         * 
         * @return builder
         * 
         */
        public Builder desiredReplicas(Integer desiredReplicas) {
            return desiredReplicas(Output.of(desiredReplicas));
        }

        /**
         * @param lastScaleTime lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.
         * 
         * @return builder
         * 
         */
        public Builder lastScaleTime(@Nullable Output<String> lastScaleTime) {
            $.lastScaleTime = lastScaleTime;
            return this;
        }

        /**
         * @param lastScaleTime lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.
         * 
         * @return builder
         * 
         */
        public Builder lastScaleTime(String lastScaleTime) {
            return lastScaleTime(Output.of(lastScaleTime));
        }

        /**
         * @param observedGeneration observedGeneration is the most recent generation observed by this autoscaler.
         * 
         * @return builder
         * 
         */
        public Builder observedGeneration(@Nullable Output<Integer> observedGeneration) {
            $.observedGeneration = observedGeneration;
            return this;
        }

        /**
         * @param observedGeneration observedGeneration is the most recent generation observed by this autoscaler.
         * 
         * @return builder
         * 
         */
        public Builder observedGeneration(Integer observedGeneration) {
            return observedGeneration(Output.of(observedGeneration));
        }

        public HorizontalPodAutoscalerStatusArgs build() {
            if ($.currentReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatusArgs", "currentReplicas");
            }
            if ($.desiredReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatusArgs", "desiredReplicas");
            }
            return $;
        }
    }

}
