// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v2.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2.inputs.MetricValueStatusArgs;
import java.lang.String;
import java.util.Objects;


/**
 * ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the &#34;pods&#34; source.
 * 
 */
public final class ContainerResourceMetricStatusArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContainerResourceMetricStatusArgs Empty = new ContainerResourceMetricStatusArgs();

    /**
     * container is the name of the container in the pods of the scaling target
     * 
     */
    @Import(name="container", required=true)
    private Output<String> container;

    /**
     * @return container is the name of the container in the pods of the scaling target
     * 
     */
    public Output<String> container() {
        return this.container;
    }

    /**
     * current contains the current value for the given metric
     * 
     */
    @Import(name="current", required=true)
    private Output<MetricValueStatusArgs> current;

    /**
     * @return current contains the current value for the given metric
     * 
     */
    public Output<MetricValueStatusArgs> current() {
        return this.current;
    }

    /**
     * name is the name of the resource in question.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return name is the name of the resource in question.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    private ContainerResourceMetricStatusArgs() {}

    private ContainerResourceMetricStatusArgs(ContainerResourceMetricStatusArgs $) {
        this.container = $.container;
        this.current = $.current;
        this.name = $.name;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerResourceMetricStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerResourceMetricStatusArgs $;

        public Builder() {
            $ = new ContainerResourceMetricStatusArgs();
        }

        public Builder(ContainerResourceMetricStatusArgs defaults) {
            $ = new ContainerResourceMetricStatusArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param container container is the name of the container in the pods of the scaling target
         * 
         * @return builder
         * 
         */
        public Builder container(Output<String> container) {
            $.container = container;
            return this;
        }

        /**
         * @param container container is the name of the container in the pods of the scaling target
         * 
         * @return builder
         * 
         */
        public Builder container(String container) {
            return container(Output.of(container));
        }

        /**
         * @param current current contains the current value for the given metric
         * 
         * @return builder
         * 
         */
        public Builder current(Output<MetricValueStatusArgs> current) {
            $.current = current;
            return this;
        }

        /**
         * @param current current contains the current value for the given metric
         * 
         * @return builder
         * 
         */
        public Builder current(MetricValueStatusArgs current) {
            return current(Output.of(current));
        }

        /**
         * @param name name is the name of the resource in question.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name name is the name of the resource in question.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        public ContainerResourceMetricStatusArgs build() {
            if ($.container == null) {
                throw new MissingRequiredPropertyException("ContainerResourceMetricStatusArgs", "container");
            }
            if ($.current == null) {
                throw new MissingRequiredPropertyException("ContainerResourceMetricStatusArgs", "current");
            }
            if ($.name == null) {
                throw new MissingRequiredPropertyException("ContainerResourceMetricStatusArgs", "name");
            }
            return $;
        }
    }

}
