// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v2.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.autoscaling.v2.inputs.HPAScalingPolicyPatchArgs;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.
 * 
 */
public final class HPAScalingRulesPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final HPAScalingRulesPatchArgs Empty = new HPAScalingRulesPatchArgs();

    /**
     * policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
     * 
     */
    @Import(name="policies")
    private @Nullable Output<List<HPAScalingPolicyPatchArgs>> policies;

    /**
     * @return policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
     * 
     */
    public Optional<Output<List<HPAScalingPolicyPatchArgs>>> policies() {
        return Optional.ofNullable(this.policies);
    }

    /**
     * selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
     * 
     */
    @Import(name="selectPolicy")
    private @Nullable Output<String> selectPolicy;

    /**
     * @return selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
     * 
     */
    public Optional<Output<String>> selectPolicy() {
        return Optional.ofNullable(this.selectPolicy);
    }

    /**
     * stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
     * 
     */
    @Import(name="stabilizationWindowSeconds")
    private @Nullable Output<Integer> stabilizationWindowSeconds;

    /**
     * @return stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
     * 
     */
    public Optional<Output<Integer>> stabilizationWindowSeconds() {
        return Optional.ofNullable(this.stabilizationWindowSeconds);
    }

    private HPAScalingRulesPatchArgs() {}

    private HPAScalingRulesPatchArgs(HPAScalingRulesPatchArgs $) {
        this.policies = $.policies;
        this.selectPolicy = $.selectPolicy;
        this.stabilizationWindowSeconds = $.stabilizationWindowSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(HPAScalingRulesPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HPAScalingRulesPatchArgs $;

        public Builder() {
            $ = new HPAScalingRulesPatchArgs();
        }

        public Builder(HPAScalingRulesPatchArgs defaults) {
            $ = new HPAScalingRulesPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param policies policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
         * 
         * @return builder
         * 
         */
        public Builder policies(@Nullable Output<List<HPAScalingPolicyPatchArgs>> policies) {
            $.policies = policies;
            return this;
        }

        /**
         * @param policies policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
         * 
         * @return builder
         * 
         */
        public Builder policies(List<HPAScalingPolicyPatchArgs> policies) {
            return policies(Output.of(policies));
        }

        /**
         * @param policies policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
         * 
         * @return builder
         * 
         */
        public Builder policies(HPAScalingPolicyPatchArgs... policies) {
            return policies(List.of(policies));
        }

        /**
         * @param selectPolicy selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
         * 
         * @return builder
         * 
         */
        public Builder selectPolicy(@Nullable Output<String> selectPolicy) {
            $.selectPolicy = selectPolicy;
            return this;
        }

        /**
         * @param selectPolicy selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
         * 
         * @return builder
         * 
         */
        public Builder selectPolicy(String selectPolicy) {
            return selectPolicy(Output.of(selectPolicy));
        }

        /**
         * @param stabilizationWindowSeconds stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
         * 
         * @return builder
         * 
         */
        public Builder stabilizationWindowSeconds(@Nullable Output<Integer> stabilizationWindowSeconds) {
            $.stabilizationWindowSeconds = stabilizationWindowSeconds;
            return this;
        }

        /**
         * @param stabilizationWindowSeconds stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
         * 
         * @return builder
         * 
         */
        public Builder stabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
            return stabilizationWindowSeconds(Output.of(stabilizationWindowSeconds));
        }

        public HPAScalingRulesPatchArgs build() {
            return $;
        }
    }

}
