// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2.outputs.CrossVersionObjectReference;
import com.pulumi.kubernetes.autoscaling.v2.outputs.HorizontalPodAutoscalerBehavior;
import com.pulumi.kubernetes.autoscaling.v2.outputs.MetricSpec;
import java.lang.Integer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerSpec {
    /**
     * @return behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
     * 
     */
    private @Nullable HorizontalPodAutoscalerBehavior behavior;
    /**
     * @return maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
     * 
     */
    private Integer maxReplicas;
    /**
     * @return metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
     * 
     */
    private @Nullable List<MetricSpec> metrics;
    /**
     * @return minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     * 
     */
    private @Nullable Integer minReplicas;
    /**
     * @return scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
     * 
     */
    private CrossVersionObjectReference scaleTargetRef;

    private HorizontalPodAutoscalerSpec() {}
    /**
     * @return behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
     * 
     */
    public Optional<HorizontalPodAutoscalerBehavior> behavior() {
        return Optional.ofNullable(this.behavior);
    }
    /**
     * @return maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
     * 
     */
    public Integer maxReplicas() {
        return this.maxReplicas;
    }
    /**
     * @return metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
     * 
     */
    public List<MetricSpec> metrics() {
        return this.metrics == null ? List.of() : this.metrics;
    }
    /**
     * @return minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     * 
     */
    public Optional<Integer> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }
    /**
     * @return scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
     * 
     */
    public CrossVersionObjectReference scaleTargetRef() {
        return this.scaleTargetRef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerSpec defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable HorizontalPodAutoscalerBehavior behavior;
        private Integer maxReplicas;
        private @Nullable List<MetricSpec> metrics;
        private @Nullable Integer minReplicas;
        private CrossVersionObjectReference scaleTargetRef;
        public Builder() {}
        public Builder(HorizontalPodAutoscalerSpec defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.behavior = defaults.behavior;
    	      this.maxReplicas = defaults.maxReplicas;
    	      this.metrics = defaults.metrics;
    	      this.minReplicas = defaults.minReplicas;
    	      this.scaleTargetRef = defaults.scaleTargetRef;
        }

        @CustomType.Setter
        public Builder behavior(@Nullable HorizontalPodAutoscalerBehavior behavior) {

            this.behavior = behavior;
            return this;
        }
        @CustomType.Setter
        public Builder maxReplicas(Integer maxReplicas) {
            if (maxReplicas == null) {
              throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpec", "maxReplicas");
            }
            this.maxReplicas = maxReplicas;
            return this;
        }
        @CustomType.Setter
        public Builder metrics(@Nullable List<MetricSpec> metrics) {

            this.metrics = metrics;
            return this;
        }
        public Builder metrics(MetricSpec... metrics) {
            return metrics(List.of(metrics));
        }
        @CustomType.Setter
        public Builder minReplicas(@Nullable Integer minReplicas) {

            this.minReplicas = minReplicas;
            return this;
        }
        @CustomType.Setter
        public Builder scaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
            if (scaleTargetRef == null) {
              throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpec", "scaleTargetRef");
            }
            this.scaleTargetRef = scaleTargetRef;
            return this;
        }
        public HorizontalPodAutoscalerSpec build() {
            final var _resultValue = new HorizontalPodAutoscalerSpec();
            _resultValue.behavior = behavior;
            _resultValue.maxReplicas = maxReplicas;
            _resultValue.metrics = metrics;
            _resultValue.minReplicas = minReplicas;
            _resultValue.scaleTargetRef = scaleTargetRef;
            return _resultValue;
        }
    }
}
