// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v2beta1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the &#34;pods&#34; source.  Only one &#34;target&#34; type should be set.
 * 
 */
public final class ContainerResourceMetricSourcePatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContainerResourceMetricSourcePatchArgs Empty = new ContainerResourceMetricSourcePatchArgs();

    /**
     * container is the name of the container in the pods of the scaling target
     * 
     */
    @Import(name="container")
    private @Nullable Output<String> container;

    /**
     * @return container is the name of the container in the pods of the scaling target
     * 
     */
    public Optional<Output<String>> container() {
        return Optional.ofNullable(this.container);
    }

    /**
     * name is the name of the resource in question.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return name is the name of the resource in question.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
     * 
     */
    @Import(name="targetAverageUtilization")
    private @Nullable Output<Integer> targetAverageUtilization;

    /**
     * @return targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
     * 
     */
    public Optional<Output<Integer>> targetAverageUtilization() {
        return Optional.ofNullable(this.targetAverageUtilization);
    }

    /**
     * targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the &#34;pods&#34; metric source type.
     * 
     */
    @Import(name="targetAverageValue")
    private @Nullable Output<String> targetAverageValue;

    /**
     * @return targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the &#34;pods&#34; metric source type.
     * 
     */
    public Optional<Output<String>> targetAverageValue() {
        return Optional.ofNullable(this.targetAverageValue);
    }

    private ContainerResourceMetricSourcePatchArgs() {}

    private ContainerResourceMetricSourcePatchArgs(ContainerResourceMetricSourcePatchArgs $) {
        this.container = $.container;
        this.name = $.name;
        this.targetAverageUtilization = $.targetAverageUtilization;
        this.targetAverageValue = $.targetAverageValue;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerResourceMetricSourcePatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerResourceMetricSourcePatchArgs $;

        public Builder() {
            $ = new ContainerResourceMetricSourcePatchArgs();
        }

        public Builder(ContainerResourceMetricSourcePatchArgs defaults) {
            $ = new ContainerResourceMetricSourcePatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param container container is the name of the container in the pods of the scaling target
         * 
         * @return builder
         * 
         */
        public Builder container(@Nullable Output<String> container) {
            $.container = container;
            return this;
        }

        /**
         * @param container container is the name of the container in the pods of the scaling target
         * 
         * @return builder
         * 
         */
        public Builder container(String container) {
            return container(Output.of(container));
        }

        /**
         * @param name name is the name of the resource in question.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name name is the name of the resource in question.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param targetAverageUtilization targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
         * 
         * @return builder
         * 
         */
        public Builder targetAverageUtilization(@Nullable Output<Integer> targetAverageUtilization) {
            $.targetAverageUtilization = targetAverageUtilization;
            return this;
        }

        /**
         * @param targetAverageUtilization targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
         * 
         * @return builder
         * 
         */
        public Builder targetAverageUtilization(Integer targetAverageUtilization) {
            return targetAverageUtilization(Output.of(targetAverageUtilization));
        }

        /**
         * @param targetAverageValue targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the &#34;pods&#34; metric source type.
         * 
         * @return builder
         * 
         */
        public Builder targetAverageValue(@Nullable Output<String> targetAverageValue) {
            $.targetAverageValue = targetAverageValue;
            return this;
        }

        /**
         * @param targetAverageValue targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the &#34;pods&#34; metric source type.
         * 
         * @return builder
         * 
         */
        public Builder targetAverageValue(String targetAverageValue) {
            return targetAverageValue(Output.of(targetAverageValue));
        }

        public ContainerResourceMetricSourcePatchArgs build() {
            return $;
        }
    }

}
