// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.autoscaling.v2beta2.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2beta2.inputs.CrossVersionObjectReferenceArgs;
import com.pulumi.kubernetes.autoscaling.v2beta2.inputs.HorizontalPodAutoscalerBehaviorArgs;
import com.pulumi.kubernetes.autoscaling.v2beta2.inputs.MetricSpecArgs;
import java.lang.Integer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
 * 
 */
public final class HorizontalPodAutoscalerSpecArgs extends com.pulumi.resources.ResourceArgs {

    public static final HorizontalPodAutoscalerSpecArgs Empty = new HorizontalPodAutoscalerSpecArgs();

    /**
     * behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
     * 
     */
    @Import(name="behavior")
    private @Nullable Output<HorizontalPodAutoscalerBehaviorArgs> behavior;

    /**
     * @return behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
     * 
     */
    public Optional<Output<HorizontalPodAutoscalerBehaviorArgs>> behavior() {
        return Optional.ofNullable(this.behavior);
    }

    /**
     * maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
     * 
     */
    @Import(name="maxReplicas", required=true)
    private Output<Integer> maxReplicas;

    /**
     * @return maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
     * 
     */
    public Output<Integer> maxReplicas() {
        return this.maxReplicas;
    }

    /**
     * metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
     * 
     */
    @Import(name="metrics")
    private @Nullable Output<List<MetricSpecArgs>> metrics;

    /**
     * @return metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
     * 
     */
    public Optional<Output<List<MetricSpecArgs>>> metrics() {
        return Optional.ofNullable(this.metrics);
    }

    /**
     * minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     * 
     */
    @Import(name="minReplicas")
    private @Nullable Output<Integer> minReplicas;

    /**
     * @return minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     * 
     */
    public Optional<Output<Integer>> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    /**
     * scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
     * 
     */
    @Import(name="scaleTargetRef", required=true)
    private Output<CrossVersionObjectReferenceArgs> scaleTargetRef;

    /**
     * @return scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
     * 
     */
    public Output<CrossVersionObjectReferenceArgs> scaleTargetRef() {
        return this.scaleTargetRef;
    }

    private HorizontalPodAutoscalerSpecArgs() {}

    private HorizontalPodAutoscalerSpecArgs(HorizontalPodAutoscalerSpecArgs $) {
        this.behavior = $.behavior;
        this.maxReplicas = $.maxReplicas;
        this.metrics = $.metrics;
        this.minReplicas = $.minReplicas;
        this.scaleTargetRef = $.scaleTargetRef;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(HorizontalPodAutoscalerSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HorizontalPodAutoscalerSpecArgs $;

        public Builder() {
            $ = new HorizontalPodAutoscalerSpecArgs();
        }

        public Builder(HorizontalPodAutoscalerSpecArgs defaults) {
            $ = new HorizontalPodAutoscalerSpecArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param behavior behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
         * 
         * @return builder
         * 
         */
        public Builder behavior(@Nullable Output<HorizontalPodAutoscalerBehaviorArgs> behavior) {
            $.behavior = behavior;
            return this;
        }

        /**
         * @param behavior behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
         * 
         * @return builder
         * 
         */
        public Builder behavior(HorizontalPodAutoscalerBehaviorArgs behavior) {
            return behavior(Output.of(behavior));
        }

        /**
         * @param maxReplicas maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
         * 
         * @return builder
         * 
         */
        public Builder maxReplicas(Output<Integer> maxReplicas) {
            $.maxReplicas = maxReplicas;
            return this;
        }

        /**
         * @param maxReplicas maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
         * 
         * @return builder
         * 
         */
        public Builder maxReplicas(Integer maxReplicas) {
            return maxReplicas(Output.of(maxReplicas));
        }

        /**
         * @param metrics metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
         * 
         * @return builder
         * 
         */
        public Builder metrics(@Nullable Output<List<MetricSpecArgs>> metrics) {
            $.metrics = metrics;
            return this;
        }

        /**
         * @param metrics metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
         * 
         * @return builder
         * 
         */
        public Builder metrics(List<MetricSpecArgs> metrics) {
            return metrics(Output.of(metrics));
        }

        /**
         * @param metrics metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
         * 
         * @return builder
         * 
         */
        public Builder metrics(MetricSpecArgs... metrics) {
            return metrics(List.of(metrics));
        }

        /**
         * @param minReplicas minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
         * 
         * @return builder
         * 
         */
        public Builder minReplicas(@Nullable Output<Integer> minReplicas) {
            $.minReplicas = minReplicas;
            return this;
        }

        /**
         * @param minReplicas minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
         * 
         * @return builder
         * 
         */
        public Builder minReplicas(Integer minReplicas) {
            return minReplicas(Output.of(minReplicas));
        }

        /**
         * @param scaleTargetRef scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
         * 
         * @return builder
         * 
         */
        public Builder scaleTargetRef(Output<CrossVersionObjectReferenceArgs> scaleTargetRef) {
            $.scaleTargetRef = scaleTargetRef;
            return this;
        }

        /**
         * @param scaleTargetRef scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
         * 
         * @return builder
         * 
         */
        public Builder scaleTargetRef(CrossVersionObjectReferenceArgs scaleTargetRef) {
            return scaleTargetRef(Output.of(scaleTargetRef));
        }

        public HorizontalPodAutoscalerSpecArgs build() {
            if ($.maxReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpecArgs", "maxReplicas");
            }
            if ($.scaleTargetRef == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpecArgs", "scaleTargetRef");
            }
            return $;
        }
    }

}
