// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.batch.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.batch.v1.inputs.JobTemplateSpecArgs;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * CronJobSpec describes how the job execution will look like and when it will actually run.
 * 
 */
public final class CronJobSpecArgs extends com.pulumi.resources.ResourceArgs {

    public static final CronJobSpecArgs Empty = new CronJobSpecArgs();

    /**
     * Specifies how to treat concurrent executions of a Job. Valid values are:
     * 
     * - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
     * 
     */
    @Import(name="concurrencyPolicy")
    private @Nullable Output<String> concurrencyPolicy;

    /**
     * @return Specifies how to treat concurrent executions of a Job. Valid values are:
     * 
     * - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
     * 
     */
    public Optional<Output<String>> concurrencyPolicy() {
        return Optional.ofNullable(this.concurrencyPolicy);
    }

    /**
     * The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
     * 
     */
    @Import(name="failedJobsHistoryLimit")
    private @Nullable Output<Integer> failedJobsHistoryLimit;

    /**
     * @return The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
     * 
     */
    public Optional<Output<Integer>> failedJobsHistoryLimit() {
        return Optional.ofNullable(this.failedJobsHistoryLimit);
    }

    /**
     * Specifies the job that will be created when executing a CronJob.
     * 
     */
    @Import(name="jobTemplate", required=true)
    private Output<JobTemplateSpecArgs> jobTemplate;

    /**
     * @return Specifies the job that will be created when executing a CronJob.
     * 
     */
    public Output<JobTemplateSpecArgs> jobTemplate() {
        return this.jobTemplate;
    }

    /**
     * The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
     * 
     */
    @Import(name="schedule", required=true)
    private Output<String> schedule;

    /**
     * @return The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
     * 
     */
    public Output<String> schedule() {
        return this.schedule;
    }

    /**
     * Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
     * 
     */
    @Import(name="startingDeadlineSeconds")
    private @Nullable Output<Integer> startingDeadlineSeconds;

    /**
     * @return Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
     * 
     */
    public Optional<Output<Integer>> startingDeadlineSeconds() {
        return Optional.ofNullable(this.startingDeadlineSeconds);
    }

    /**
     * The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
     * 
     */
    @Import(name="successfulJobsHistoryLimit")
    private @Nullable Output<Integer> successfulJobsHistoryLimit;

    /**
     * @return The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
     * 
     */
    public Optional<Output<Integer>> successfulJobsHistoryLimit() {
        return Optional.ofNullable(this.successfulJobsHistoryLimit);
    }

    /**
     * This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
     * 
     */
    @Import(name="suspend")
    private @Nullable Output<Boolean> suspend;

    /**
     * @return This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
     * 
     */
    public Optional<Output<Boolean>> suspend() {
        return Optional.ofNullable(this.suspend);
    }

    /**
     * The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
     * 
     */
    @Import(name="timeZone")
    private @Nullable Output<String> timeZone;

    /**
     * @return The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
     * 
     */
    public Optional<Output<String>> timeZone() {
        return Optional.ofNullable(this.timeZone);
    }

    private CronJobSpecArgs() {}

    private CronJobSpecArgs(CronJobSpecArgs $) {
        this.concurrencyPolicy = $.concurrencyPolicy;
        this.failedJobsHistoryLimit = $.failedJobsHistoryLimit;
        this.jobTemplate = $.jobTemplate;
        this.schedule = $.schedule;
        this.startingDeadlineSeconds = $.startingDeadlineSeconds;
        this.successfulJobsHistoryLimit = $.successfulJobsHistoryLimit;
        this.suspend = $.suspend;
        this.timeZone = $.timeZone;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CronJobSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CronJobSpecArgs $;

        public Builder() {
            $ = new CronJobSpecArgs();
        }

        public Builder(CronJobSpecArgs defaults) {
            $ = new CronJobSpecArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param concurrencyPolicy Specifies how to treat concurrent executions of a Job. Valid values are:
         * 
         * - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
         * 
         * @return builder
         * 
         */
        public Builder concurrencyPolicy(@Nullable Output<String> concurrencyPolicy) {
            $.concurrencyPolicy = concurrencyPolicy;
            return this;
        }

        /**
         * @param concurrencyPolicy Specifies how to treat concurrent executions of a Job. Valid values are:
         * 
         * - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
         * 
         * @return builder
         * 
         */
        public Builder concurrencyPolicy(String concurrencyPolicy) {
            return concurrencyPolicy(Output.of(concurrencyPolicy));
        }

        /**
         * @param failedJobsHistoryLimit The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
         * 
         * @return builder
         * 
         */
        public Builder failedJobsHistoryLimit(@Nullable Output<Integer> failedJobsHistoryLimit) {
            $.failedJobsHistoryLimit = failedJobsHistoryLimit;
            return this;
        }

        /**
         * @param failedJobsHistoryLimit The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
         * 
         * @return builder
         * 
         */
        public Builder failedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
            return failedJobsHistoryLimit(Output.of(failedJobsHistoryLimit));
        }

        /**
         * @param jobTemplate Specifies the job that will be created when executing a CronJob.
         * 
         * @return builder
         * 
         */
        public Builder jobTemplate(Output<JobTemplateSpecArgs> jobTemplate) {
            $.jobTemplate = jobTemplate;
            return this;
        }

        /**
         * @param jobTemplate Specifies the job that will be created when executing a CronJob.
         * 
         * @return builder
         * 
         */
        public Builder jobTemplate(JobTemplateSpecArgs jobTemplate) {
            return jobTemplate(Output.of(jobTemplate));
        }

        /**
         * @param schedule The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
         * 
         * @return builder
         * 
         */
        public Builder schedule(Output<String> schedule) {
            $.schedule = schedule;
            return this;
        }

        /**
         * @param schedule The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
         * 
         * @return builder
         * 
         */
        public Builder schedule(String schedule) {
            return schedule(Output.of(schedule));
        }

        /**
         * @param startingDeadlineSeconds Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
         * 
         * @return builder
         * 
         */
        public Builder startingDeadlineSeconds(@Nullable Output<Integer> startingDeadlineSeconds) {
            $.startingDeadlineSeconds = startingDeadlineSeconds;
            return this;
        }

        /**
         * @param startingDeadlineSeconds Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
         * 
         * @return builder
         * 
         */
        public Builder startingDeadlineSeconds(Integer startingDeadlineSeconds) {
            return startingDeadlineSeconds(Output.of(startingDeadlineSeconds));
        }

        /**
         * @param successfulJobsHistoryLimit The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
         * 
         * @return builder
         * 
         */
        public Builder successfulJobsHistoryLimit(@Nullable Output<Integer> successfulJobsHistoryLimit) {
            $.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
            return this;
        }

        /**
         * @param successfulJobsHistoryLimit The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
         * 
         * @return builder
         * 
         */
        public Builder successfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
            return successfulJobsHistoryLimit(Output.of(successfulJobsHistoryLimit));
        }

        /**
         * @param suspend This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder suspend(@Nullable Output<Boolean> suspend) {
            $.suspend = suspend;
            return this;
        }

        /**
         * @param suspend This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder suspend(Boolean suspend) {
            return suspend(Output.of(suspend));
        }

        /**
         * @param timeZone The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
         * 
         * @return builder
         * 
         */
        public Builder timeZone(@Nullable Output<String> timeZone) {
            $.timeZone = timeZone;
            return this;
        }

        /**
         * @param timeZone The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
         * 
         * @return builder
         * 
         */
        public Builder timeZone(String timeZone) {
            return timeZone(Output.of(timeZone));
        }

        public CronJobSpecArgs build() {
            if ($.jobTemplate == null) {
                throw new MissingRequiredPropertyException("CronJobSpecArgs", "jobTemplate");
            }
            if ($.schedule == null) {
                throw new MissingRequiredPropertyException("CronJobSpecArgs", "schedule");
            }
            return $;
        }
    }

}
