// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.batch.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.
 * 
 */
public final class PodFailurePolicyOnExitCodesRequirementPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final PodFailurePolicyOnExitCodesRequirementPatchArgs Empty = new PodFailurePolicyOnExitCodesRequirementPatchArgs();

    /**
     * Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
     * 
     */
    @Import(name="containerName")
    private @Nullable Output<String> containerName;

    /**
     * @return Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
     * 
     */
    public Optional<Output<String>> containerName() {
        return Optional.ofNullable(this.containerName);
    }

    /**
     * Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:
     * 
     * - In: the requirement is satisfied if at least one container exit code
     *   (might be multiple if there are multiple containers not restricted
     *   by the &#39;containerName&#39; field) is in the set of specified values.
     * - NotIn: the requirement is satisfied if at least one container exit code
     *   (might be multiple if there are multiple containers not restricted
     *   by the &#39;containerName&#39; field) is not in the set of specified values.
     *   Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
     * 
     */
    @Import(name="operator")
    private @Nullable Output<String> operator;

    /**
     * @return Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:
     * 
     * - In: the requirement is satisfied if at least one container exit code
     *   (might be multiple if there are multiple containers not restricted
     *   by the &#39;containerName&#39; field) is in the set of specified values.
     * - NotIn: the requirement is satisfied if at least one container exit code
     *   (might be multiple if there are multiple containers not restricted
     *   by the &#39;containerName&#39; field) is not in the set of specified values.
     *   Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
     * 
     */
    public Optional<Output<String>> operator() {
        return Optional.ofNullable(this.operator);
    }

    /**
     * Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value &#39;0&#39; cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
     * 
     */
    @Import(name="values")
    private @Nullable Output<List<Integer>> values;

    /**
     * @return Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value &#39;0&#39; cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
     * 
     */
    public Optional<Output<List<Integer>>> values() {
        return Optional.ofNullable(this.values);
    }

    private PodFailurePolicyOnExitCodesRequirementPatchArgs() {}

    private PodFailurePolicyOnExitCodesRequirementPatchArgs(PodFailurePolicyOnExitCodesRequirementPatchArgs $) {
        this.containerName = $.containerName;
        this.operator = $.operator;
        this.values = $.values;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PodFailurePolicyOnExitCodesRequirementPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PodFailurePolicyOnExitCodesRequirementPatchArgs $;

        public Builder() {
            $ = new PodFailurePolicyOnExitCodesRequirementPatchArgs();
        }

        public Builder(PodFailurePolicyOnExitCodesRequirementPatchArgs defaults) {
            $ = new PodFailurePolicyOnExitCodesRequirementPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param containerName Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
         * 
         * @return builder
         * 
         */
        public Builder containerName(@Nullable Output<String> containerName) {
            $.containerName = containerName;
            return this;
        }

        /**
         * @param containerName Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
         * 
         * @return builder
         * 
         */
        public Builder containerName(String containerName) {
            return containerName(Output.of(containerName));
        }

        /**
         * @param operator Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:
         * 
         * - In: the requirement is satisfied if at least one container exit code
         *   (might be multiple if there are multiple containers not restricted
         *   by the &#39;containerName&#39; field) is in the set of specified values.
         * - NotIn: the requirement is satisfied if at least one container exit code
         *   (might be multiple if there are multiple containers not restricted
         *   by the &#39;containerName&#39; field) is not in the set of specified values.
         *   Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
         * 
         * @return builder
         * 
         */
        public Builder operator(@Nullable Output<String> operator) {
            $.operator = operator;
            return this;
        }

        /**
         * @param operator Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:
         * 
         * - In: the requirement is satisfied if at least one container exit code
         *   (might be multiple if there are multiple containers not restricted
         *   by the &#39;containerName&#39; field) is in the set of specified values.
         * - NotIn: the requirement is satisfied if at least one container exit code
         *   (might be multiple if there are multiple containers not restricted
         *   by the &#39;containerName&#39; field) is not in the set of specified values.
         *   Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
         * 
         * @return builder
         * 
         */
        public Builder operator(String operator) {
            return operator(Output.of(operator));
        }

        /**
         * @param values Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value &#39;0&#39; cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
         * 
         * @return builder
         * 
         */
        public Builder values(@Nullable Output<List<Integer>> values) {
            $.values = values;
            return this;
        }

        /**
         * @param values Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value &#39;0&#39; cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
         * 
         * @return builder
         * 
         */
        public Builder values(List<Integer> values) {
            return values(Output.of(values));
        }

        /**
         * @param values Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value &#39;0&#39; cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
         * 
         * @return builder
         * 
         */
        public Builder values(Integer... values) {
            return values(List.of(values));
        }

        public PodFailurePolicyOnExitCodesRequirementPatchArgs build() {
            return $;
        }
    }

}
