// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.batch.v2alpha1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.batch.v2alpha1.inputs.JobTemplateSpecArgs;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * CronJobSpec describes how the job execution will look like and when it will actually run.
 * 
 */
public final class CronJobSpecArgs extends com.pulumi.resources.ResourceArgs {

    public static final CronJobSpecArgs Empty = new CronJobSpecArgs();

    /**
     * Specifies how to treat concurrent executions of a Job. Valid values are: - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
     * 
     */
    @Import(name="concurrencyPolicy")
    private @Nullable Output<String> concurrencyPolicy;

    /**
     * @return Specifies how to treat concurrent executions of a Job. Valid values are: - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
     * 
     */
    public Optional<Output<String>> concurrencyPolicy() {
        return Optional.ofNullable(this.concurrencyPolicy);
    }

    /**
     * The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
     * 
     */
    @Import(name="failedJobsHistoryLimit")
    private @Nullable Output<Integer> failedJobsHistoryLimit;

    /**
     * @return The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
     * 
     */
    public Optional<Output<Integer>> failedJobsHistoryLimit() {
        return Optional.ofNullable(this.failedJobsHistoryLimit);
    }

    /**
     * Specifies the job that will be created when executing a CronJob.
     * 
     */
    @Import(name="jobTemplate", required=true)
    private Output<JobTemplateSpecArgs> jobTemplate;

    /**
     * @return Specifies the job that will be created when executing a CronJob.
     * 
     */
    public Output<JobTemplateSpecArgs> jobTemplate() {
        return this.jobTemplate;
    }

    /**
     * The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
     * 
     */
    @Import(name="schedule", required=true)
    private Output<String> schedule;

    /**
     * @return The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
     * 
     */
    public Output<String> schedule() {
        return this.schedule;
    }

    /**
     * Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
     * 
     */
    @Import(name="startingDeadlineSeconds")
    private @Nullable Output<Integer> startingDeadlineSeconds;

    /**
     * @return Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
     * 
     */
    public Optional<Output<Integer>> startingDeadlineSeconds() {
        return Optional.ofNullable(this.startingDeadlineSeconds);
    }

    /**
     * The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
     * 
     */
    @Import(name="successfulJobsHistoryLimit")
    private @Nullable Output<Integer> successfulJobsHistoryLimit;

    /**
     * @return The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
     * 
     */
    public Optional<Output<Integer>> successfulJobsHistoryLimit() {
        return Optional.ofNullable(this.successfulJobsHistoryLimit);
    }

    /**
     * This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
     * 
     */
    @Import(name="suspend")
    private @Nullable Output<Boolean> suspend;

    /**
     * @return This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
     * 
     */
    public Optional<Output<Boolean>> suspend() {
        return Optional.ofNullable(this.suspend);
    }

    private CronJobSpecArgs() {}

    private CronJobSpecArgs(CronJobSpecArgs $) {
        this.concurrencyPolicy = $.concurrencyPolicy;
        this.failedJobsHistoryLimit = $.failedJobsHistoryLimit;
        this.jobTemplate = $.jobTemplate;
        this.schedule = $.schedule;
        this.startingDeadlineSeconds = $.startingDeadlineSeconds;
        this.successfulJobsHistoryLimit = $.successfulJobsHistoryLimit;
        this.suspend = $.suspend;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CronJobSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CronJobSpecArgs $;

        public Builder() {
            $ = new CronJobSpecArgs();
        }

        public Builder(CronJobSpecArgs defaults) {
            $ = new CronJobSpecArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param concurrencyPolicy Specifies how to treat concurrent executions of a Job. Valid values are: - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
         * 
         * @return builder
         * 
         */
        public Builder concurrencyPolicy(@Nullable Output<String> concurrencyPolicy) {
            $.concurrencyPolicy = concurrencyPolicy;
            return this;
        }

        /**
         * @param concurrencyPolicy Specifies how to treat concurrent executions of a Job. Valid values are: - &#34;Allow&#34; (default): allows CronJobs to run concurrently; - &#34;Forbid&#34;: forbids concurrent runs, skipping next run if previous run hasn&#39;t finished yet; - &#34;Replace&#34;: cancels currently running job and replaces it with a new one
         * 
         * @return builder
         * 
         */
        public Builder concurrencyPolicy(String concurrencyPolicy) {
            return concurrencyPolicy(Output.of(concurrencyPolicy));
        }

        /**
         * @param failedJobsHistoryLimit The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
         * 
         * @return builder
         * 
         */
        public Builder failedJobsHistoryLimit(@Nullable Output<Integer> failedJobsHistoryLimit) {
            $.failedJobsHistoryLimit = failedJobsHistoryLimit;
            return this;
        }

        /**
         * @param failedJobsHistoryLimit The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
         * 
         * @return builder
         * 
         */
        public Builder failedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
            return failedJobsHistoryLimit(Output.of(failedJobsHistoryLimit));
        }

        /**
         * @param jobTemplate Specifies the job that will be created when executing a CronJob.
         * 
         * @return builder
         * 
         */
        public Builder jobTemplate(Output<JobTemplateSpecArgs> jobTemplate) {
            $.jobTemplate = jobTemplate;
            return this;
        }

        /**
         * @param jobTemplate Specifies the job that will be created when executing a CronJob.
         * 
         * @return builder
         * 
         */
        public Builder jobTemplate(JobTemplateSpecArgs jobTemplate) {
            return jobTemplate(Output.of(jobTemplate));
        }

        /**
         * @param schedule The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
         * 
         * @return builder
         * 
         */
        public Builder schedule(Output<String> schedule) {
            $.schedule = schedule;
            return this;
        }

        /**
         * @param schedule The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
         * 
         * @return builder
         * 
         */
        public Builder schedule(String schedule) {
            return schedule(Output.of(schedule));
        }

        /**
         * @param startingDeadlineSeconds Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
         * 
         * @return builder
         * 
         */
        public Builder startingDeadlineSeconds(@Nullable Output<Integer> startingDeadlineSeconds) {
            $.startingDeadlineSeconds = startingDeadlineSeconds;
            return this;
        }

        /**
         * @param startingDeadlineSeconds Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
         * 
         * @return builder
         * 
         */
        public Builder startingDeadlineSeconds(Integer startingDeadlineSeconds) {
            return startingDeadlineSeconds(Output.of(startingDeadlineSeconds));
        }

        /**
         * @param successfulJobsHistoryLimit The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
         * 
         * @return builder
         * 
         */
        public Builder successfulJobsHistoryLimit(@Nullable Output<Integer> successfulJobsHistoryLimit) {
            $.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
            return this;
        }

        /**
         * @param successfulJobsHistoryLimit The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
         * 
         * @return builder
         * 
         */
        public Builder successfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
            return successfulJobsHistoryLimit(Output.of(successfulJobsHistoryLimit));
        }

        /**
         * @param suspend This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder suspend(@Nullable Output<Boolean> suspend) {
            $.suspend = suspend;
            return this;
        }

        /**
         * @param suspend This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder suspend(Boolean suspend) {
            return suspend(Output.of(suspend));
        }

        public CronJobSpecArgs build() {
            if ($.jobTemplate == null) {
                throw new MissingRequiredPropertyException("CronJobSpecArgs", "jobTemplate");
            }
            if ($.schedule == null) {
                throw new MissingRequiredPropertyException("CronJobSpecArgs", "schedule");
            }
            return $;
        }
    }

}
