// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.certificates.v1;

import com.pulumi.core.Alias;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.certificates.v1.CertificateSigningRequestArgs;
import com.pulumi.kubernetes.certificates.v1.outputs.CertificateSigningRequestSpec;
import com.pulumi.kubernetes.certificates.v1.outputs.CertificateSigningRequestStatus;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.
 * 
 * Kubelets use this API to obtain:
 *  1. client certificates to authenticate to kube-apiserver (with the &#34;kubernetes.io/kube-apiserver-client-kubelet&#34; signerName).
 *  2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the &#34;kubernetes.io/kubelet-serving&#34; signerName).
 * 
 * This API can be used to request client certificates to authenticate to kube-apiserver (with the &#34;kubernetes.io/kube-apiserver-client&#34; signerName), or to obtain certificates from custom non-Kubernetes signers.
 * 
 */
@ResourceType(type="kubernetes:certificates.k8s.io/v1:CertificateSigningRequest")
public class CertificateSigningRequest extends com.pulumi.resources.CustomResource {
    /**
     * APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output<String> apiVersion;

    /**
     * @return APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    public Output<String> apiVersion() {
        return this.apiVersion;
    }
    /**
     * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output<String> kind;

    /**
     * @return Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    public Output<String> kind() {
        return this.kind;
    }
    @Export(name="metadata", refs={ObjectMeta.class}, tree="[0]")
    private Output<ObjectMeta> metadata;

    public Output<ObjectMeta> metadata() {
        return this.metadata;
    }
    /**
     * spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
     * 
     */
    @Export(name="spec", refs={CertificateSigningRequestSpec.class}, tree="[0]")
    private Output<CertificateSigningRequestSpec> spec;

    /**
     * @return spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
     * 
     */
    public Output<CertificateSigningRequestSpec> spec() {
        return this.spec;
    }
    /**
     * status contains information about whether the request is approved or denied, and the certificate issued by the signer, or the failure condition indicating signer failure.
     * 
     */
    @Export(name="status", refs={CertificateSigningRequestStatus.class}, tree="[0]")
    private Output</* @Nullable */ CertificateSigningRequestStatus> status;

    /**
     * @return status contains information about whether the request is approved or denied, and the certificate issued by the signer, or the failure condition indicating signer failure.
     * 
     */
    public Output<Optional<CertificateSigningRequestStatus>> status() {
        return Codegen.optional(this.status);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CertificateSigningRequest(String name) {
        this(name, CertificateSigningRequestArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CertificateSigningRequest(String name, CertificateSigningRequestArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CertificateSigningRequest(String name, CertificateSigningRequestArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("kubernetes:certificates.k8s.io/v1:CertificateSigningRequest", name, makeArgs(args, options), makeResourceOptions(options, Codegen.empty()));
    }

    private CertificateSigningRequest(String name, Output<String> id, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("kubernetes:certificates.k8s.io/v1:CertificateSigningRequest", name, null, makeResourceOptions(options, id));
    }

    private static CertificateSigningRequestArgs makeArgs(CertificateSigningRequestArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        if (options != null && options.getUrn().isPresent()) {
            return null;
        }
        var builder = args == null ? CertificateSigningRequestArgs.builder() : CertificateSigningRequestArgs.builder(args);
        return builder
            .apiVersion("certificates.k8s.io/v1")
            .kind("CertificateSigningRequest")
            .build();
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .aliases(List.of(
                Output.of(Alias.builder().type("kubernetes:certificates.k8s.io/v1beta1:CertificateSigningRequest").build())
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CertificateSigningRequest get(String name, Output<String> id, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CertificateSigningRequest(name, id, options);
    }
}
