// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.certificates.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CertificateSigningRequestSpecPatch {
    /**
     * @return expirationSeconds is the requested duration of validity of the issued certificate. The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration.
     * 
     * The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager.
     * 
     * Certificate signers may not honor this field for various reasons:
     * 
     *   1. Old signer that is unaware of the field (such as the in-tree
     *      implementations prior to v1.22)
     *   2. Signer whose configured maximum is shorter than the requested duration
     *   3. Signer whose configured minimum is longer than the requested duration
     * 
     * The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.
     * 
     */
    private @Nullable Integer expirationSeconds;
    /**
     * @return extra contains extra attributes of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    private @Nullable Map<String,List<String>> extra;
    /**
     * @return groups contains group membership of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    private @Nullable List<String> groups;
    /**
     * @return request contains an x509 certificate signing request encoded in a &#34;CERTIFICATE REQUEST&#34; PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.
     * 
     */
    private @Nullable String request;
    /**
     * @return signerName indicates the requested signer, and is a qualified name.
     * 
     * List/watch requests for CertificateSigningRequests can filter on this field using a &#34;spec.signerName=NAME&#34; fieldSelector.
     * 
     * Well-known Kubernetes signers are:
     *  1. &#34;kubernetes.io/kube-apiserver-client&#34;: issues client certificates that can be used to authenticate to kube-apiserver.
     *       Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the &#34;csrsigning&#34; controller in kube-controller-manager.
     *  2. &#34;kubernetes.io/kube-apiserver-client-kubelet&#34;: issues client certificates that kubelets use to authenticate to kube-apiserver.
     *       Requests for this signer can be auto-approved by the &#34;csrapproving&#34; controller in kube-controller-manager, and can be issued by the &#34;csrsigning&#34; controller in kube-controller-manager.
     *  3. &#34;kubernetes.io/kubelet-serving&#34; issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
     *       Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the &#34;csrsigning&#34; controller in kube-controller-manager.
     * 
     * More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers
     * 
     * Custom signerNames can also be specified. The signer defines:
     *  1. Trust distribution: how trust (CA bundles) are distributed.
     *  2. Permitted subjects: and behavior when a disallowed subject is requested.
     *  3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
     *  4. Required, permitted, or forbidden key usages / extended key usages.
     *  5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
     *  6. Whether or not requests for CA certificates are allowed.
     * 
     */
    private @Nullable String signerName;
    /**
     * @return uid contains the uid of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    private @Nullable String uid;
    /**
     * @return usages specifies a set of key usages requested in the issued certificate.
     * 
     * Requests for TLS client certificates typically request: &#34;digital signature&#34;, &#34;key encipherment&#34;, &#34;client auth&#34;.
     * 
     * Requests for TLS serving certificates typically request: &#34;key encipherment&#34;, &#34;digital signature&#34;, &#34;server auth&#34;.
     * 
     * Valid values are:
     *  &#34;signing&#34;, &#34;digital signature&#34;, &#34;content commitment&#34;,
     *  &#34;key encipherment&#34;, &#34;key agreement&#34;, &#34;data encipherment&#34;,
     *  &#34;cert sign&#34;, &#34;crl sign&#34;, &#34;encipher only&#34;, &#34;decipher only&#34;, &#34;any&#34;,
     *  &#34;server auth&#34;, &#34;client auth&#34;,
     *  &#34;code signing&#34;, &#34;email protection&#34;, &#34;s/mime&#34;,
     *  &#34;ipsec end system&#34;, &#34;ipsec tunnel&#34;, &#34;ipsec user&#34;,
     *  &#34;timestamping&#34;, &#34;ocsp signing&#34;, &#34;microsoft sgc&#34;, &#34;netscape sgc&#34;
     * 
     */
    private @Nullable List<String> usages;
    /**
     * @return username contains the name of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    private @Nullable String username;

    private CertificateSigningRequestSpecPatch() {}
    /**
     * @return expirationSeconds is the requested duration of validity of the issued certificate. The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration.
     * 
     * The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager.
     * 
     * Certificate signers may not honor this field for various reasons:
     * 
     *   1. Old signer that is unaware of the field (such as the in-tree
     *      implementations prior to v1.22)
     *   2. Signer whose configured maximum is shorter than the requested duration
     *   3. Signer whose configured minimum is longer than the requested duration
     * 
     * The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.
     * 
     */
    public Optional<Integer> expirationSeconds() {
        return Optional.ofNullable(this.expirationSeconds);
    }
    /**
     * @return extra contains extra attributes of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    public Map<String,List<String>> extra() {
        return this.extra == null ? Map.of() : this.extra;
    }
    /**
     * @return groups contains group membership of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    public List<String> groups() {
        return this.groups == null ? List.of() : this.groups;
    }
    /**
     * @return request contains an x509 certificate signing request encoded in a &#34;CERTIFICATE REQUEST&#34; PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.
     * 
     */
    public Optional<String> request() {
        return Optional.ofNullable(this.request);
    }
    /**
     * @return signerName indicates the requested signer, and is a qualified name.
     * 
     * List/watch requests for CertificateSigningRequests can filter on this field using a &#34;spec.signerName=NAME&#34; fieldSelector.
     * 
     * Well-known Kubernetes signers are:
     *  1. &#34;kubernetes.io/kube-apiserver-client&#34;: issues client certificates that can be used to authenticate to kube-apiserver.
     *       Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the &#34;csrsigning&#34; controller in kube-controller-manager.
     *  2. &#34;kubernetes.io/kube-apiserver-client-kubelet&#34;: issues client certificates that kubelets use to authenticate to kube-apiserver.
     *       Requests for this signer can be auto-approved by the &#34;csrapproving&#34; controller in kube-controller-manager, and can be issued by the &#34;csrsigning&#34; controller in kube-controller-manager.
     *  3. &#34;kubernetes.io/kubelet-serving&#34; issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
     *       Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the &#34;csrsigning&#34; controller in kube-controller-manager.
     * 
     * More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers
     * 
     * Custom signerNames can also be specified. The signer defines:
     *  1. Trust distribution: how trust (CA bundles) are distributed.
     *  2. Permitted subjects: and behavior when a disallowed subject is requested.
     *  3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
     *  4. Required, permitted, or forbidden key usages / extended key usages.
     *  5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
     *  6. Whether or not requests for CA certificates are allowed.
     * 
     */
    public Optional<String> signerName() {
        return Optional.ofNullable(this.signerName);
    }
    /**
     * @return uid contains the uid of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    public Optional<String> uid() {
        return Optional.ofNullable(this.uid);
    }
    /**
     * @return usages specifies a set of key usages requested in the issued certificate.
     * 
     * Requests for TLS client certificates typically request: &#34;digital signature&#34;, &#34;key encipherment&#34;, &#34;client auth&#34;.
     * 
     * Requests for TLS serving certificates typically request: &#34;key encipherment&#34;, &#34;digital signature&#34;, &#34;server auth&#34;.
     * 
     * Valid values are:
     *  &#34;signing&#34;, &#34;digital signature&#34;, &#34;content commitment&#34;,
     *  &#34;key encipherment&#34;, &#34;key agreement&#34;, &#34;data encipherment&#34;,
     *  &#34;cert sign&#34;, &#34;crl sign&#34;, &#34;encipher only&#34;, &#34;decipher only&#34;, &#34;any&#34;,
     *  &#34;server auth&#34;, &#34;client auth&#34;,
     *  &#34;code signing&#34;, &#34;email protection&#34;, &#34;s/mime&#34;,
     *  &#34;ipsec end system&#34;, &#34;ipsec tunnel&#34;, &#34;ipsec user&#34;,
     *  &#34;timestamping&#34;, &#34;ocsp signing&#34;, &#34;microsoft sgc&#34;, &#34;netscape sgc&#34;
     * 
     */
    public List<String> usages() {
        return this.usages == null ? List.of() : this.usages;
    }
    /**
     * @return username contains the name of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
     * 
     */
    public Optional<String> username() {
        return Optional.ofNullable(this.username);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CertificateSigningRequestSpecPatch defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Integer expirationSeconds;
        private @Nullable Map<String,List<String>> extra;
        private @Nullable List<String> groups;
        private @Nullable String request;
        private @Nullable String signerName;
        private @Nullable String uid;
        private @Nullable List<String> usages;
        private @Nullable String username;
        public Builder() {}
        public Builder(CertificateSigningRequestSpecPatch defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.expirationSeconds = defaults.expirationSeconds;
    	      this.extra = defaults.extra;
    	      this.groups = defaults.groups;
    	      this.request = defaults.request;
    	      this.signerName = defaults.signerName;
    	      this.uid = defaults.uid;
    	      this.usages = defaults.usages;
    	      this.username = defaults.username;
        }

        @CustomType.Setter
        public Builder expirationSeconds(@Nullable Integer expirationSeconds) {

            this.expirationSeconds = expirationSeconds;
            return this;
        }
        @CustomType.Setter
        public Builder extra(@Nullable Map<String,List<String>> extra) {

            this.extra = extra;
            return this;
        }
        @CustomType.Setter
        public Builder groups(@Nullable List<String> groups) {

            this.groups = groups;
            return this;
        }
        public Builder groups(String... groups) {
            return groups(List.of(groups));
        }
        @CustomType.Setter
        public Builder request(@Nullable String request) {

            this.request = request;
            return this;
        }
        @CustomType.Setter
        public Builder signerName(@Nullable String signerName) {

            this.signerName = signerName;
            return this;
        }
        @CustomType.Setter
        public Builder uid(@Nullable String uid) {

            this.uid = uid;
            return this;
        }
        @CustomType.Setter
        public Builder usages(@Nullable List<String> usages) {

            this.usages = usages;
            return this;
        }
        public Builder usages(String... usages) {
            return usages(List.of(usages));
        }
        @CustomType.Setter
        public Builder username(@Nullable String username) {

            this.username = username;
            return this;
        }
        public CertificateSigningRequestSpecPatch build() {
            final var _resultValue = new CertificateSigningRequestSpecPatch();
            _resultValue.expirationSeconds = expirationSeconds;
            _resultValue.extra = extra;
            _resultValue.groups = groups;
            _resultValue.request = request;
            _resultValue.signerName = signerName;
            _resultValue.uid = uid;
            _resultValue.usages = usages;
            _resultValue.username = username;
            return _resultValue;
        }
    }
}
