// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.certificates.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.certificates.v1.outputs.CertificateSigningRequestCondition;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CertificateSigningRequestStatus {
    /**
     * @return certificate is populated with an issued certificate by the signer after an Approved condition is present. This field is set via the /status subresource. Once populated, this field is immutable.
     * 
     * If the certificate signing request is denied, a condition of type &#34;Denied&#34; is added and this field remains empty. If the signer cannot issue the certificate, a condition of type &#34;Failed&#34; is added and this field remains empty.
     * 
     * Validation requirements:
     *  1. certificate must contain one or more PEM blocks.
     *  2. All PEM blocks must have the &#34;CERTIFICATE&#34; label, contain no headers, and the encoded data
     *       must be a BER-encoded ASN.1 Certificate structure as described in section 4 of RFC5280.
     *  3. Non-PEM content may appear before or after the &#34;CERTIFICATE&#34; PEM blocks and is unvalidated,
     *       to allow for explanatory text as described in section 5.2 of RFC7468.
     * 
     * If more than one PEM block is present, and the definition of the requested spec.signerName does not indicate otherwise, the first block is the issued certificate, and subsequent blocks should be treated as intermediate certificates and presented in TLS handshakes.
     * 
     * The certificate is encoded in PEM format.
     * 
     * When serialized as JSON or YAML, the data is additionally base64-encoded, so it consists of:
     * 
     *     base64(
     *     -----BEGIN CERTIFICATE-----
     *     ...
     *     -----END CERTIFICATE-----
     *     )
     * 
     */
    private @Nullable String certificate;
    /**
     * @return conditions applied to the request. Known conditions are &#34;Approved&#34;, &#34;Denied&#34;, and &#34;Failed&#34;.
     * 
     */
    private @Nullable List<CertificateSigningRequestCondition> conditions;

    private CertificateSigningRequestStatus() {}
    /**
     * @return certificate is populated with an issued certificate by the signer after an Approved condition is present. This field is set via the /status subresource. Once populated, this field is immutable.
     * 
     * If the certificate signing request is denied, a condition of type &#34;Denied&#34; is added and this field remains empty. If the signer cannot issue the certificate, a condition of type &#34;Failed&#34; is added and this field remains empty.
     * 
     * Validation requirements:
     *  1. certificate must contain one or more PEM blocks.
     *  2. All PEM blocks must have the &#34;CERTIFICATE&#34; label, contain no headers, and the encoded data
     *       must be a BER-encoded ASN.1 Certificate structure as described in section 4 of RFC5280.
     *  3. Non-PEM content may appear before or after the &#34;CERTIFICATE&#34; PEM blocks and is unvalidated,
     *       to allow for explanatory text as described in section 5.2 of RFC7468.
     * 
     * If more than one PEM block is present, and the definition of the requested spec.signerName does not indicate otherwise, the first block is the issued certificate, and subsequent blocks should be treated as intermediate certificates and presented in TLS handshakes.
     * 
     * The certificate is encoded in PEM format.
     * 
     * When serialized as JSON or YAML, the data is additionally base64-encoded, so it consists of:
     * 
     *     base64(
     *     -----BEGIN CERTIFICATE-----
     *     ...
     *     -----END CERTIFICATE-----
     *     )
     * 
     */
    public Optional<String> certificate() {
        return Optional.ofNullable(this.certificate);
    }
    /**
     * @return conditions applied to the request. Known conditions are &#34;Approved&#34;, &#34;Denied&#34;, and &#34;Failed&#34;.
     * 
     */
    public List<CertificateSigningRequestCondition> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CertificateSigningRequestStatus defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String certificate;
        private @Nullable List<CertificateSigningRequestCondition> conditions;
        public Builder() {}
        public Builder(CertificateSigningRequestStatus defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.certificate = defaults.certificate;
    	      this.conditions = defaults.conditions;
        }

        @CustomType.Setter
        public Builder certificate(@Nullable String certificate) {

            this.certificate = certificate;
            return this;
        }
        @CustomType.Setter
        public Builder conditions(@Nullable List<CertificateSigningRequestCondition> conditions) {

            this.conditions = conditions;
            return this;
        }
        public Builder conditions(CertificateSigningRequestCondition... conditions) {
            return conditions(List.of(conditions));
        }
        public CertificateSigningRequestStatus build() {
            final var _resultValue = new CertificateSigningRequestStatus();
            _resultValue.certificate = certificate;
            _resultValue.conditions = conditions;
            return _resultValue;
        }
    }
}
