// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1;

import com.pulumi.core.Alias;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.core.v1.EventArgs;
import com.pulumi.kubernetes.core.v1.outputs.EventSeries;
import com.pulumi.kubernetes.core.v1.outputs.EventSource;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 * 
 */
@ResourceType(type="kubernetes:core/v1:Event")
public class Event extends com.pulumi.resources.CustomResource {
    /**
     * What action was taken/failed regarding to the Regarding object.
     * 
     */
    @Export(name="action", refs={String.class}, tree="[0]")
    private Output<String> action;

    /**
     * @return What action was taken/failed regarding to the Regarding object.
     * 
     */
    public Output<String> action() {
        return this.action;
    }
    /**
     * APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output<String> apiVersion;

    /**
     * @return APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    public Output<String> apiVersion() {
        return this.apiVersion;
    }
    /**
     * The number of times this event has occurred.
     * 
     */
    @Export(name="count", refs={Integer.class}, tree="[0]")
    private Output<Integer> count;

    /**
     * @return The number of times this event has occurred.
     * 
     */
    public Output<Integer> count() {
        return this.count;
    }
    /**
     * Time when this Event was first observed.
     * 
     */
    @Export(name="eventTime", refs={String.class}, tree="[0]")
    private Output<String> eventTime;

    /**
     * @return Time when this Event was first observed.
     * 
     */
    public Output<String> eventTime() {
        return this.eventTime;
    }
    /**
     * The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
     * 
     */
    @Export(name="firstTimestamp", refs={String.class}, tree="[0]")
    private Output<String> firstTimestamp;

    /**
     * @return The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
     * 
     */
    public Output<String> firstTimestamp() {
        return this.firstTimestamp;
    }
    /**
     * The object that this event is about.
     * 
     */
    @Export(name="involvedObject", refs={ObjectReference.class}, tree="[0]")
    private Output<ObjectReference> involvedObject;

    /**
     * @return The object that this event is about.
     * 
     */
    public Output<ObjectReference> involvedObject() {
        return this.involvedObject;
    }
    /**
     * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output<String> kind;

    /**
     * @return Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    public Output<String> kind() {
        return this.kind;
    }
    /**
     * The time at which the most recent occurrence of this event was recorded.
     * 
     */
    @Export(name="lastTimestamp", refs={String.class}, tree="[0]")
    private Output<String> lastTimestamp;

    /**
     * @return The time at which the most recent occurrence of this event was recorded.
     * 
     */
    public Output<String> lastTimestamp() {
        return this.lastTimestamp;
    }
    /**
     * A human-readable description of the status of this operation.
     * 
     */
    @Export(name="message", refs={String.class}, tree="[0]")
    private Output<String> message;

    /**
     * @return A human-readable description of the status of this operation.
     * 
     */
    public Output<String> message() {
        return this.message;
    }
    /**
     * Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    @Export(name="metadata", refs={ObjectMeta.class}, tree="[0]")
    private Output<ObjectMeta> metadata;

    /**
     * @return Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    public Output<ObjectMeta> metadata() {
        return this.metadata;
    }
    /**
     * This should be a short, machine understandable string that gives the reason for the transition into the object&#39;s current status.
     * 
     */
    @Export(name="reason", refs={String.class}, tree="[0]")
    private Output<String> reason;

    /**
     * @return This should be a short, machine understandable string that gives the reason for the transition into the object&#39;s current status.
     * 
     */
    public Output<String> reason() {
        return this.reason;
    }
    /**
     * Optional secondary object for more complex actions.
     * 
     */
    @Export(name="related", refs={ObjectReference.class}, tree="[0]")
    private Output<ObjectReference> related;

    /**
     * @return Optional secondary object for more complex actions.
     * 
     */
    public Output<ObjectReference> related() {
        return this.related;
    }
    /**
     * Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
     * 
     */
    @Export(name="reportingComponent", refs={String.class}, tree="[0]")
    private Output<String> reportingComponent;

    /**
     * @return Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
     * 
     */
    public Output<String> reportingComponent() {
        return this.reportingComponent;
    }
    /**
     * ID of the controller instance, e.g. `kubelet-xyzf`.
     * 
     */
    @Export(name="reportingInstance", refs={String.class}, tree="[0]")
    private Output<String> reportingInstance;

    /**
     * @return ID of the controller instance, e.g. `kubelet-xyzf`.
     * 
     */
    public Output<String> reportingInstance() {
        return this.reportingInstance;
    }
    /**
     * Data about the Event series this event represents or nil if it&#39;s a singleton Event.
     * 
     */
    @Export(name="series", refs={EventSeries.class}, tree="[0]")
    private Output<EventSeries> series;

    /**
     * @return Data about the Event series this event represents or nil if it&#39;s a singleton Event.
     * 
     */
    public Output<EventSeries> series() {
        return this.series;
    }
    /**
     * The component reporting this event. Should be a short machine understandable string.
     * 
     */
    @Export(name="source", refs={EventSource.class}, tree="[0]")
    private Output<EventSource> source;

    /**
     * @return The component reporting this event. Should be a short machine understandable string.
     * 
     */
    public Output<EventSource> source() {
        return this.source;
    }
    /**
     * Type of this event (Normal, Warning), new types could be added in the future
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return Type of this event (Normal, Warning), new types could be added in the future
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Event(String name) {
        this(name, EventArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Event(String name, EventArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Event(String name, EventArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("kubernetes:core/v1:Event", name, makeArgs(args, options), makeResourceOptions(options, Codegen.empty()));
    }

    private Event(String name, Output<String> id, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("kubernetes:core/v1:Event", name, null, makeResourceOptions(options, id));
    }

    private static EventArgs makeArgs(EventArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        if (options != null && options.getUrn().isPresent()) {
            return null;
        }
        var builder = args == null ? EventArgs.builder() : EventArgs.builder(args);
        return builder
            .apiVersion("v1")
            .kind("Event")
            .build();
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .aliases(List.of(
                Output.of(Alias.builder().type("kubernetes:events.k8s.io/v1:Event").build()),
                Output.of(Alias.builder().type("kubernetes:events.k8s.io/v1beta1:Event").build())
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Event get(String name, Output<String> id, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Event(name, id, options);
    }
}
