// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1;

import com.pulumi.core.Alias;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.core.v1.EventPatchArgs;
import com.pulumi.kubernetes.core.v1.outputs.EventSeriesPatch;
import com.pulumi.kubernetes.core.v1.outputs.EventSourcePatch;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReferencePatch;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMetaPatch;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Patch resources are used to modify existing Kubernetes resources by using
 * Server-Side Apply updates. The name of the resource must be specified, but all other properties are optional. More than
 * one patch may be applied to the same resource, and a random FieldManager name will be used for each Patch resource.
 * Conflicts will result in an error by default, but can be forced using the &#34;pulumi.com/patchForce&#34; annotation. See the
 * [Server-Side Apply Docs](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/managing-resources-with-server-side-apply/) for
 * additional information about using Server-Side Apply to manage Kubernetes resources with Pulumi.
 * Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 * 
 */
@ResourceType(type="kubernetes:core/v1:EventPatch")
public class EventPatch extends com.pulumi.resources.CustomResource {
    /**
     * What action was taken/failed regarding to the Regarding object.
     * 
     */
    @Export(name="action", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> action;

    /**
     * @return What action was taken/failed regarding to the Regarding object.
     * 
     */
    public Output<Optional<String>> action() {
        return Codegen.optional(this.action);
    }
    /**
     * APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> apiVersion;

    /**
     * @return APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     * 
     */
    public Output<Optional<String>> apiVersion() {
        return Codegen.optional(this.apiVersion);
    }
    /**
     * The number of times this event has occurred.
     * 
     */
    @Export(name="count", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> count;

    /**
     * @return The number of times this event has occurred.
     * 
     */
    public Output<Optional<Integer>> count() {
        return Codegen.optional(this.count);
    }
    /**
     * Time when this Event was first observed.
     * 
     */
    @Export(name="eventTime", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> eventTime;

    /**
     * @return Time when this Event was first observed.
     * 
     */
    public Output<Optional<String>> eventTime() {
        return Codegen.optional(this.eventTime);
    }
    /**
     * The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
     * 
     */
    @Export(name="firstTimestamp", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> firstTimestamp;

    /**
     * @return The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
     * 
     */
    public Output<Optional<String>> firstTimestamp() {
        return Codegen.optional(this.firstTimestamp);
    }
    /**
     * The object that this event is about.
     * 
     */
    @Export(name="involvedObject", refs={ObjectReferencePatch.class}, tree="[0]")
    private Output</* @Nullable */ ObjectReferencePatch> involvedObject;

    /**
     * @return The object that this event is about.
     * 
     */
    public Output<Optional<ObjectReferencePatch>> involvedObject() {
        return Codegen.optional(this.involvedObject);
    }
    /**
     * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kind;

    /**
     * @return Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * 
     */
    public Output<Optional<String>> kind() {
        return Codegen.optional(this.kind);
    }
    /**
     * The time at which the most recent occurrence of this event was recorded.
     * 
     */
    @Export(name="lastTimestamp", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> lastTimestamp;

    /**
     * @return The time at which the most recent occurrence of this event was recorded.
     * 
     */
    public Output<Optional<String>> lastTimestamp() {
        return Codegen.optional(this.lastTimestamp);
    }
    /**
     * A human-readable description of the status of this operation.
     * 
     */
    @Export(name="message", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> message;

    /**
     * @return A human-readable description of the status of this operation.
     * 
     */
    public Output<Optional<String>> message() {
        return Codegen.optional(this.message);
    }
    /**
     * Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    @Export(name="metadata", refs={ObjectMetaPatch.class}, tree="[0]")
    private Output</* @Nullable */ ObjectMetaPatch> metadata;

    /**
     * @return Standard object&#39;s metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * 
     */
    public Output<Optional<ObjectMetaPatch>> metadata() {
        return Codegen.optional(this.metadata);
    }
    /**
     * This should be a short, machine understandable string that gives the reason for the transition into the object&#39;s current status.
     * 
     */
    @Export(name="reason", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> reason;

    /**
     * @return This should be a short, machine understandable string that gives the reason for the transition into the object&#39;s current status.
     * 
     */
    public Output<Optional<String>> reason() {
        return Codegen.optional(this.reason);
    }
    /**
     * Optional secondary object for more complex actions.
     * 
     */
    @Export(name="related", refs={ObjectReferencePatch.class}, tree="[0]")
    private Output</* @Nullable */ ObjectReferencePatch> related;

    /**
     * @return Optional secondary object for more complex actions.
     * 
     */
    public Output<Optional<ObjectReferencePatch>> related() {
        return Codegen.optional(this.related);
    }
    /**
     * Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
     * 
     */
    @Export(name="reportingComponent", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> reportingComponent;

    /**
     * @return Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
     * 
     */
    public Output<Optional<String>> reportingComponent() {
        return Codegen.optional(this.reportingComponent);
    }
    /**
     * ID of the controller instance, e.g. `kubelet-xyzf`.
     * 
     */
    @Export(name="reportingInstance", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> reportingInstance;

    /**
     * @return ID of the controller instance, e.g. `kubelet-xyzf`.
     * 
     */
    public Output<Optional<String>> reportingInstance() {
        return Codegen.optional(this.reportingInstance);
    }
    /**
     * Data about the Event series this event represents or nil if it&#39;s a singleton Event.
     * 
     */
    @Export(name="series", refs={EventSeriesPatch.class}, tree="[0]")
    private Output</* @Nullable */ EventSeriesPatch> series;

    /**
     * @return Data about the Event series this event represents or nil if it&#39;s a singleton Event.
     * 
     */
    public Output<Optional<EventSeriesPatch>> series() {
        return Codegen.optional(this.series);
    }
    /**
     * The component reporting this event. Should be a short machine understandable string.
     * 
     */
    @Export(name="source", refs={EventSourcePatch.class}, tree="[0]")
    private Output</* @Nullable */ EventSourcePatch> source;

    /**
     * @return The component reporting this event. Should be a short machine understandable string.
     * 
     */
    public Output<Optional<EventSourcePatch>> source() {
        return Codegen.optional(this.source);
    }
    /**
     * Type of this event (Normal, Warning), new types could be added in the future
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> type;

    /**
     * @return Type of this event (Normal, Warning), new types could be added in the future
     * 
     */
    public Output<Optional<String>> type() {
        return Codegen.optional(this.type);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EventPatch(String name) {
        this(name, EventPatchArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EventPatch(String name, @Nullable EventPatchArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EventPatch(String name, @Nullable EventPatchArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("kubernetes:core/v1:EventPatch", name, makeArgs(args, options), makeResourceOptions(options, Codegen.empty()));
    }

    private EventPatch(String name, Output<String> id, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("kubernetes:core/v1:EventPatch", name, null, makeResourceOptions(options, id));
    }

    private static EventPatchArgs makeArgs(@Nullable EventPatchArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        if (options != null && options.getUrn().isPresent()) {
            return null;
        }
        var builder = args == null ? EventPatchArgs.builder() : EventPatchArgs.builder(args);
        return builder
            .apiVersion("v1")
            .kind("Event")
            .build();
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .aliases(List.of(
                Output.of(Alias.builder().type("kubernetes:events.k8s.io/v1:EventPatch").build()),
                Output.of(Alias.builder().type("kubernetes:events.k8s.io/v1beta1:EventPatch").build())
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EventPatch get(String name, Output<String> id, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EventPatch(name, id, options);
    }
}
