// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;


/**
 * ContainerResizePolicy represents resource resize policy for the container.
 * 
 */
public final class ContainerResizePolicyArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContainerResizePolicyArgs Empty = new ContainerResizePolicyArgs();

    /**
     * Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
     * 
     */
    @Import(name="resourceName", required=true)
    private Output<String> resourceName;

    /**
     * @return Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
     * 
     */
    public Output<String> resourceName() {
        return this.resourceName;
    }

    /**
     * Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
     * 
     */
    @Import(name="restartPolicy", required=true)
    private Output<String> restartPolicy;

    /**
     * @return Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
     * 
     */
    public Output<String> restartPolicy() {
        return this.restartPolicy;
    }

    private ContainerResizePolicyArgs() {}

    private ContainerResizePolicyArgs(ContainerResizePolicyArgs $) {
        this.resourceName = $.resourceName;
        this.restartPolicy = $.restartPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerResizePolicyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerResizePolicyArgs $;

        public Builder() {
            $ = new ContainerResizePolicyArgs();
        }

        public Builder(ContainerResizePolicyArgs defaults) {
            $ = new ContainerResizePolicyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param resourceName Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
         * 
         * @return builder
         * 
         */
        public Builder resourceName(Output<String> resourceName) {
            $.resourceName = resourceName;
            return this;
        }

        /**
         * @param resourceName Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
         * 
         * @return builder
         * 
         */
        public Builder resourceName(String resourceName) {
            return resourceName(Output.of(resourceName));
        }

        /**
         * @param restartPolicy Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
         * 
         * @return builder
         * 
         */
        public Builder restartPolicy(Output<String> restartPolicy) {
            $.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * @param restartPolicy Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
         * 
         * @return builder
         * 
         */
        public Builder restartPolicy(String restartPolicy) {
            return restartPolicy(Output.of(restartPolicy));
        }

        public ContainerResizePolicyArgs build() {
            if ($.resourceName == null) {
                throw new MissingRequiredPropertyException("ContainerResizePolicyArgs", "resourceName");
            }
            if ($.restartPolicy == null) {
                throw new MissingRequiredPropertyException("ContainerResizePolicyArgs", "restartPolicy");
            }
            return $;
        }
    }

}
