// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.ContainerStateArgs;
import com.pulumi.kubernetes.core.v1.inputs.ContainerUserArgs;
import com.pulumi.kubernetes.core.v1.inputs.ResourceRequirementsArgs;
import com.pulumi.kubernetes.core.v1.inputs.ResourceStatusArgs;
import com.pulumi.kubernetes.core.v1.inputs.VolumeMountStatusArgs;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ContainerStatus contains details for the current status of this container.
 * 
 */
public final class ContainerStatusArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContainerStatusArgs Empty = new ContainerStatusArgs();

    /**
     * AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
     * 
     */
    @Import(name="allocatedResources")
    private @Nullable Output<Map<String,String>> allocatedResources;

    /**
     * @return AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
     * 
     */
    public Optional<Output<Map<String,String>>> allocatedResources() {
        return Optional.ofNullable(this.allocatedResources);
    }

    /**
     * AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
     * 
     */
    @Import(name="allocatedResourcesStatus")
    private @Nullable Output<List<ResourceStatusArgs>> allocatedResourcesStatus;

    /**
     * @return AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
     * 
     */
    public Optional<Output<List<ResourceStatusArgs>>> allocatedResourcesStatus() {
        return Optional.ofNullable(this.allocatedResourcesStatus);
    }

    /**
     * ContainerID is the ID of the container in the format &#39;&lt;type&gt;://&lt;container_id&gt;&#39;. Where type is a container runtime identifier, returned from Version call of CRI API (for example &#34;containerd&#34;).
     * 
     */
    @Import(name="containerID")
    private @Nullable Output<String> containerID;

    /**
     * @return ContainerID is the ID of the container in the format &#39;&lt;type&gt;://&lt;container_id&gt;&#39;. Where type is a container runtime identifier, returned from Version call of CRI API (for example &#34;containerd&#34;).
     * 
     */
    public Optional<Output<String>> containerID() {
        return Optional.ofNullable(this.containerID);
    }

    /**
     * Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
     * 
     */
    @Import(name="image", required=true)
    private Output<String> image;

    /**
     * @return Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
     * 
     */
    public Output<String> image() {
        return this.image;
    }

    /**
     * ImageID is the image ID of the container&#39;s image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
     * 
     */
    @Import(name="imageID", required=true)
    private Output<String> imageID;

    /**
     * @return ImageID is the image ID of the container&#39;s image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
     * 
     */
    public Output<String> imageID() {
        return this.imageID;
    }

    /**
     * LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
     * 
     */
    @Import(name="lastState")
    private @Nullable Output<ContainerStateArgs> lastState;

    /**
     * @return LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
     * 
     */
    public Optional<Output<ContainerStateArgs>> lastState() {
        return Optional.ofNullable(this.lastState);
    }

    /**
     * Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).
     * 
     * The value is typically used to determine whether a container is ready to accept traffic.
     * 
     */
    @Import(name="ready", required=true)
    private Output<Boolean> ready;

    /**
     * @return Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).
     * 
     * The value is typically used to determine whether a container is ready to accept traffic.
     * 
     */
    public Output<Boolean> ready() {
        return this.ready;
    }

    /**
     * Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
     * 
     */
    @Import(name="resources")
    private @Nullable Output<ResourceRequirementsArgs> resources;

    /**
     * @return Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
     * 
     */
    public Optional<Output<ResourceRequirementsArgs>> resources() {
        return Optional.ofNullable(this.resources);
    }

    /**
     * RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
     * 
     */
    @Import(name="restartCount", required=true)
    private Output<Integer> restartCount;

    /**
     * @return RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
     * 
     */
    public Output<Integer> restartCount() {
        return this.restartCount;
    }

    /**
     * Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
     * 
     */
    @Import(name="started")
    private @Nullable Output<Boolean> started;

    /**
     * @return Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
     * 
     */
    public Optional<Output<Boolean>> started() {
        return Optional.ofNullable(this.started);
    }

    /**
     * State holds details about the container&#39;s current condition.
     * 
     */
    @Import(name="state")
    private @Nullable Output<ContainerStateArgs> state;

    /**
     * @return State holds details about the container&#39;s current condition.
     * 
     */
    public Optional<Output<ContainerStateArgs>> state() {
        return Optional.ofNullable(this.state);
    }

    /**
     * User represents user identity information initially attached to the first process of the container
     * 
     */
    @Import(name="user")
    private @Nullable Output<ContainerUserArgs> user;

    /**
     * @return User represents user identity information initially attached to the first process of the container
     * 
     */
    public Optional<Output<ContainerUserArgs>> user() {
        return Optional.ofNullable(this.user);
    }

    /**
     * Status of volume mounts.
     * 
     */
    @Import(name="volumeMounts")
    private @Nullable Output<List<VolumeMountStatusArgs>> volumeMounts;

    /**
     * @return Status of volume mounts.
     * 
     */
    public Optional<Output<List<VolumeMountStatusArgs>>> volumeMounts() {
        return Optional.ofNullable(this.volumeMounts);
    }

    private ContainerStatusArgs() {}

    private ContainerStatusArgs(ContainerStatusArgs $) {
        this.allocatedResources = $.allocatedResources;
        this.allocatedResourcesStatus = $.allocatedResourcesStatus;
        this.containerID = $.containerID;
        this.image = $.image;
        this.imageID = $.imageID;
        this.lastState = $.lastState;
        this.name = $.name;
        this.ready = $.ready;
        this.resources = $.resources;
        this.restartCount = $.restartCount;
        this.started = $.started;
        this.state = $.state;
        this.user = $.user;
        this.volumeMounts = $.volumeMounts;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerStatusArgs $;

        public Builder() {
            $ = new ContainerStatusArgs();
        }

        public Builder(ContainerStatusArgs defaults) {
            $ = new ContainerStatusArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocatedResources AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResources(@Nullable Output<Map<String,String>> allocatedResources) {
            $.allocatedResources = allocatedResources;
            return this;
        }

        /**
         * @param allocatedResources AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResources(Map<String,String> allocatedResources) {
            return allocatedResources(Output.of(allocatedResources));
        }

        /**
         * @param allocatedResourcesStatus AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResourcesStatus(@Nullable Output<List<ResourceStatusArgs>> allocatedResourcesStatus) {
            $.allocatedResourcesStatus = allocatedResourcesStatus;
            return this;
        }

        /**
         * @param allocatedResourcesStatus AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResourcesStatus(List<ResourceStatusArgs> allocatedResourcesStatus) {
            return allocatedResourcesStatus(Output.of(allocatedResourcesStatus));
        }

        /**
         * @param allocatedResourcesStatus AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResourcesStatus(ResourceStatusArgs... allocatedResourcesStatus) {
            return allocatedResourcesStatus(List.of(allocatedResourcesStatus));
        }

        /**
         * @param containerID ContainerID is the ID of the container in the format &#39;&lt;type&gt;://&lt;container_id&gt;&#39;. Where type is a container runtime identifier, returned from Version call of CRI API (for example &#34;containerd&#34;).
         * 
         * @return builder
         * 
         */
        public Builder containerID(@Nullable Output<String> containerID) {
            $.containerID = containerID;
            return this;
        }

        /**
         * @param containerID ContainerID is the ID of the container in the format &#39;&lt;type&gt;://&lt;container_id&gt;&#39;. Where type is a container runtime identifier, returned from Version call of CRI API (for example &#34;containerd&#34;).
         * 
         * @return builder
         * 
         */
        public Builder containerID(String containerID) {
            return containerID(Output.of(containerID));
        }

        /**
         * @param image Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
         * 
         * @return builder
         * 
         */
        public Builder image(Output<String> image) {
            $.image = image;
            return this;
        }

        /**
         * @param image Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
         * 
         * @return builder
         * 
         */
        public Builder image(String image) {
            return image(Output.of(image));
        }

        /**
         * @param imageID ImageID is the image ID of the container&#39;s image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
         * 
         * @return builder
         * 
         */
        public Builder imageID(Output<String> imageID) {
            $.imageID = imageID;
            return this;
        }

        /**
         * @param imageID ImageID is the image ID of the container&#39;s image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
         * 
         * @return builder
         * 
         */
        public Builder imageID(String imageID) {
            return imageID(Output.of(imageID));
        }

        /**
         * @param lastState LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
         * 
         * @return builder
         * 
         */
        public Builder lastState(@Nullable Output<ContainerStateArgs> lastState) {
            $.lastState = lastState;
            return this;
        }

        /**
         * @param lastState LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
         * 
         * @return builder
         * 
         */
        public Builder lastState(ContainerStateArgs lastState) {
            return lastState(Output.of(lastState));
        }

        /**
         * @param name Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param ready Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).
         * 
         * The value is typically used to determine whether a container is ready to accept traffic.
         * 
         * @return builder
         * 
         */
        public Builder ready(Output<Boolean> ready) {
            $.ready = ready;
            return this;
        }

        /**
         * @param ready Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).
         * 
         * The value is typically used to determine whether a container is ready to accept traffic.
         * 
         * @return builder
         * 
         */
        public Builder ready(Boolean ready) {
            return ready(Output.of(ready));
        }

        /**
         * @param resources Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
         * 
         * @return builder
         * 
         */
        public Builder resources(@Nullable Output<ResourceRequirementsArgs> resources) {
            $.resources = resources;
            return this;
        }

        /**
         * @param resources Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
         * 
         * @return builder
         * 
         */
        public Builder resources(ResourceRequirementsArgs resources) {
            return resources(Output.of(resources));
        }

        /**
         * @param restartCount RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
         * 
         * @return builder
         * 
         */
        public Builder restartCount(Output<Integer> restartCount) {
            $.restartCount = restartCount;
            return this;
        }

        /**
         * @param restartCount RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
         * 
         * @return builder
         * 
         */
        public Builder restartCount(Integer restartCount) {
            return restartCount(Output.of(restartCount));
        }

        /**
         * @param started Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
         * 
         * @return builder
         * 
         */
        public Builder started(@Nullable Output<Boolean> started) {
            $.started = started;
            return this;
        }

        /**
         * @param started Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
         * 
         * @return builder
         * 
         */
        public Builder started(Boolean started) {
            return started(Output.of(started));
        }

        /**
         * @param state State holds details about the container&#39;s current condition.
         * 
         * @return builder
         * 
         */
        public Builder state(@Nullable Output<ContainerStateArgs> state) {
            $.state = state;
            return this;
        }

        /**
         * @param state State holds details about the container&#39;s current condition.
         * 
         * @return builder
         * 
         */
        public Builder state(ContainerStateArgs state) {
            return state(Output.of(state));
        }

        /**
         * @param user User represents user identity information initially attached to the first process of the container
         * 
         * @return builder
         * 
         */
        public Builder user(@Nullable Output<ContainerUserArgs> user) {
            $.user = user;
            return this;
        }

        /**
         * @param user User represents user identity information initially attached to the first process of the container
         * 
         * @return builder
         * 
         */
        public Builder user(ContainerUserArgs user) {
            return user(Output.of(user));
        }

        /**
         * @param volumeMounts Status of volume mounts.
         * 
         * @return builder
         * 
         */
        public Builder volumeMounts(@Nullable Output<List<VolumeMountStatusArgs>> volumeMounts) {
            $.volumeMounts = volumeMounts;
            return this;
        }

        /**
         * @param volumeMounts Status of volume mounts.
         * 
         * @return builder
         * 
         */
        public Builder volumeMounts(List<VolumeMountStatusArgs> volumeMounts) {
            return volumeMounts(Output.of(volumeMounts));
        }

        /**
         * @param volumeMounts Status of volume mounts.
         * 
         * @return builder
         * 
         */
        public Builder volumeMounts(VolumeMountStatusArgs... volumeMounts) {
            return volumeMounts(List.of(volumeMounts));
        }

        public ContainerStatusArgs build() {
            if ($.image == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "image");
            }
            if ($.imageID == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "imageID");
            }
            if ($.name == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "name");
            }
            if ($.ready == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "ready");
            }
            if ($.restartCount == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "restartCount");
            }
            return $;
        }
    }

}
