// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.EnvVarSourceArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * EnvVar represents an environment variable present in a Container.
 * 
 */
public final class EnvVarArgs extends com.pulumi.resources.ResourceArgs {

    public static final EnvVarArgs Empty = new EnvVarArgs();

    /**
     * Name of the environment variable. Must be a C_IDENTIFIER.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return Name of the environment variable. Must be a C_IDENTIFIER.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. &#34;$$(VAR_NAME)&#34; will produce the string literal &#34;$(VAR_NAME)&#34;. Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to &#34;&#34;.
     * 
     */
    @Import(name="value")
    private @Nullable Output<String> value;

    /**
     * @return Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. &#34;$$(VAR_NAME)&#34; will produce the string literal &#34;$(VAR_NAME)&#34;. Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to &#34;&#34;.
     * 
     */
    public Optional<Output<String>> value() {
        return Optional.ofNullable(this.value);
    }

    /**
     * Source for the environment variable&#39;s value. Cannot be used if value is not empty.
     * 
     */
    @Import(name="valueFrom")
    private @Nullable Output<EnvVarSourceArgs> valueFrom;

    /**
     * @return Source for the environment variable&#39;s value. Cannot be used if value is not empty.
     * 
     */
    public Optional<Output<EnvVarSourceArgs>> valueFrom() {
        return Optional.ofNullable(this.valueFrom);
    }

    private EnvVarArgs() {}

    private EnvVarArgs(EnvVarArgs $) {
        this.name = $.name;
        this.value = $.value;
        this.valueFrom = $.valueFrom;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EnvVarArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EnvVarArgs $;

        public Builder() {
            $ = new EnvVarArgs();
        }

        public Builder(EnvVarArgs defaults) {
            $ = new EnvVarArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name Name of the environment variable. Must be a C_IDENTIFIER.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the environment variable. Must be a C_IDENTIFIER.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param value Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. &#34;$$(VAR_NAME)&#34; will produce the string literal &#34;$(VAR_NAME)&#34;. Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to &#34;&#34;.
         * 
         * @return builder
         * 
         */
        public Builder value(@Nullable Output<String> value) {
            $.value = value;
            return this;
        }

        /**
         * @param value Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. &#34;$$(VAR_NAME)&#34; will produce the string literal &#34;$(VAR_NAME)&#34;. Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to &#34;&#34;.
         * 
         * @return builder
         * 
         */
        public Builder value(String value) {
            return value(Output.of(value));
        }

        /**
         * @param valueFrom Source for the environment variable&#39;s value. Cannot be used if value is not empty.
         * 
         * @return builder
         * 
         */
        public Builder valueFrom(@Nullable Output<EnvVarSourceArgs> valueFrom) {
            $.valueFrom = valueFrom;
            return this;
        }

        /**
         * @param valueFrom Source for the environment variable&#39;s value. Cannot be used if value is not empty.
         * 
         * @return builder
         * 
         */
        public Builder valueFrom(EnvVarSourceArgs valueFrom) {
            return valueFrom(Output.of(valueFrom));
        }

        public EnvVarArgs build() {
            if ($.name == null) {
                throw new MissingRequiredPropertyException("EnvVarArgs", "name");
            }
            return $;
        }
    }

}
