// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.HTTPHeaderPatchArgs;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * HTTPGetAction describes an action based on HTTP Get requests.
 * 
 */
public final class HTTPGetActionPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final HTTPGetActionPatchArgs Empty = new HTTPGetActionPatchArgs();

    /**
     * Host name to connect to, defaults to the pod IP. You probably want to set &#34;Host&#34; in httpHeaders instead.
     * 
     */
    @Import(name="host")
    private @Nullable Output<String> host;

    /**
     * @return Host name to connect to, defaults to the pod IP. You probably want to set &#34;Host&#34; in httpHeaders instead.
     * 
     */
    public Optional<Output<String>> host() {
        return Optional.ofNullable(this.host);
    }

    /**
     * Custom headers to set in the request. HTTP allows repeated headers.
     * 
     */
    @Import(name="httpHeaders")
    private @Nullable Output<List<HTTPHeaderPatchArgs>> httpHeaders;

    /**
     * @return Custom headers to set in the request. HTTP allows repeated headers.
     * 
     */
    public Optional<Output<List<HTTPHeaderPatchArgs>>> httpHeaders() {
        return Optional.ofNullable(this.httpHeaders);
    }

    /**
     * Path to access on the HTTP server.
     * 
     */
    @Import(name="path")
    private @Nullable Output<String> path;

    /**
     * @return Path to access on the HTTP server.
     * 
     */
    public Optional<Output<String>> path() {
        return Optional.ofNullable(this.path);
    }

    /**
     * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Either<Integer,String>> port;

    /**
     * @return Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     * 
     */
    public Optional<Output<Either<Integer,String>>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     */
    @Import(name="scheme")
    private @Nullable Output<String> scheme;

    /**
     * @return Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     */
    public Optional<Output<String>> scheme() {
        return Optional.ofNullable(this.scheme);
    }

    private HTTPGetActionPatchArgs() {}

    private HTTPGetActionPatchArgs(HTTPGetActionPatchArgs $) {
        this.host = $.host;
        this.httpHeaders = $.httpHeaders;
        this.path = $.path;
        this.port = $.port;
        this.scheme = $.scheme;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(HTTPGetActionPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HTTPGetActionPatchArgs $;

        public Builder() {
            $ = new HTTPGetActionPatchArgs();
        }

        public Builder(HTTPGetActionPatchArgs defaults) {
            $ = new HTTPGetActionPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param host Host name to connect to, defaults to the pod IP. You probably want to set &#34;Host&#34; in httpHeaders instead.
         * 
         * @return builder
         * 
         */
        public Builder host(@Nullable Output<String> host) {
            $.host = host;
            return this;
        }

        /**
         * @param host Host name to connect to, defaults to the pod IP. You probably want to set &#34;Host&#34; in httpHeaders instead.
         * 
         * @return builder
         * 
         */
        public Builder host(String host) {
            return host(Output.of(host));
        }

        /**
         * @param httpHeaders Custom headers to set in the request. HTTP allows repeated headers.
         * 
         * @return builder
         * 
         */
        public Builder httpHeaders(@Nullable Output<List<HTTPHeaderPatchArgs>> httpHeaders) {
            $.httpHeaders = httpHeaders;
            return this;
        }

        /**
         * @param httpHeaders Custom headers to set in the request. HTTP allows repeated headers.
         * 
         * @return builder
         * 
         */
        public Builder httpHeaders(List<HTTPHeaderPatchArgs> httpHeaders) {
            return httpHeaders(Output.of(httpHeaders));
        }

        /**
         * @param httpHeaders Custom headers to set in the request. HTTP allows repeated headers.
         * 
         * @return builder
         * 
         */
        public Builder httpHeaders(HTTPHeaderPatchArgs... httpHeaders) {
            return httpHeaders(List.of(httpHeaders));
        }

        /**
         * @param path Path to access on the HTTP server.
         * 
         * @return builder
         * 
         */
        public Builder path(@Nullable Output<String> path) {
            $.path = path;
            return this;
        }

        /**
         * @param path Path to access on the HTTP server.
         * 
         * @return builder
         * 
         */
        public Builder path(String path) {
            return path(Output.of(path));
        }

        /**
         * @param port Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Either<Integer,String>> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
         * 
         * @return builder
         * 
         */
        public Builder port(Either<Integer,String> port) {
            return port(Output.of(port));
        }

        /**
         * @param port Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Either.ofLeft(port));
        }

        /**
         * @param port Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
         * 
         * @return builder
         * 
         */
        public Builder port(String port) {
            return port(Either.ofRight(port));
        }

        /**
         * @param scheme Scheme to use for connecting to the host. Defaults to HTTP.
         * 
         * @return builder
         * 
         */
        public Builder scheme(@Nullable Output<String> scheme) {
            $.scheme = scheme;
            return this;
        }

        /**
         * @param scheme Scheme to use for connecting to the host. Defaults to HTTP.
         * 
         * @return builder
         * 
         */
        public Builder scheme(String scheme) {
            return scheme(Output.of(scheme));
        }

        public HTTPGetActionPatchArgs build() {
            return $;
        }
    }

}
