// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.PortStatusArgs;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
 * 
 */
public final class LoadBalancerIngressArgs extends com.pulumi.resources.ResourceArgs {

    public static final LoadBalancerIngressArgs Empty = new LoadBalancerIngressArgs();

    /**
     * Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
     * 
     */
    @Import(name="hostname")
    private @Nullable Output<String> hostname;

    /**
     * @return Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
     * 
     */
    public Optional<Output<String>> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    /**
     * IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
     * 
     */
    @Import(name="ip")
    private @Nullable Output<String> ip;

    /**
     * @return IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
     * 
     */
    public Optional<Output<String>> ip() {
        return Optional.ofNullable(this.ip);
    }

    /**
     * IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to &#34;VIP&#34; indicates that traffic is delivered to the node with the destination set to the load-balancer&#39;s IP and port. Setting this to &#34;Proxy&#34; indicates that traffic is delivered to the node or pod with the destination set to the node&#39;s IP and node port or the pod&#39;s IP and port. Service implementations may use this information to adjust traffic routing.
     * 
     */
    @Import(name="ipMode")
    private @Nullable Output<String> ipMode;

    /**
     * @return IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to &#34;VIP&#34; indicates that traffic is delivered to the node with the destination set to the load-balancer&#39;s IP and port. Setting this to &#34;Proxy&#34; indicates that traffic is delivered to the node or pod with the destination set to the node&#39;s IP and node port or the pod&#39;s IP and port. Service implementations may use this information to adjust traffic routing.
     * 
     */
    public Optional<Output<String>> ipMode() {
        return Optional.ofNullable(this.ipMode);
    }

    /**
     * Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
     * 
     */
    @Import(name="ports")
    private @Nullable Output<List<PortStatusArgs>> ports;

    /**
     * @return Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
     * 
     */
    public Optional<Output<List<PortStatusArgs>>> ports() {
        return Optional.ofNullable(this.ports);
    }

    private LoadBalancerIngressArgs() {}

    private LoadBalancerIngressArgs(LoadBalancerIngressArgs $) {
        this.hostname = $.hostname;
        this.ip = $.ip;
        this.ipMode = $.ipMode;
        this.ports = $.ports;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LoadBalancerIngressArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LoadBalancerIngressArgs $;

        public Builder() {
            $ = new LoadBalancerIngressArgs();
        }

        public Builder(LoadBalancerIngressArgs defaults) {
            $ = new LoadBalancerIngressArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param hostname Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
         * 
         * @return builder
         * 
         */
        public Builder hostname(@Nullable Output<String> hostname) {
            $.hostname = hostname;
            return this;
        }

        /**
         * @param hostname Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
         * 
         * @return builder
         * 
         */
        public Builder hostname(String hostname) {
            return hostname(Output.of(hostname));
        }

        /**
         * @param ip IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
         * 
         * @return builder
         * 
         */
        public Builder ip(@Nullable Output<String> ip) {
            $.ip = ip;
            return this;
        }

        /**
         * @param ip IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
         * 
         * @return builder
         * 
         */
        public Builder ip(String ip) {
            return ip(Output.of(ip));
        }

        /**
         * @param ipMode IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to &#34;VIP&#34; indicates that traffic is delivered to the node with the destination set to the load-balancer&#39;s IP and port. Setting this to &#34;Proxy&#34; indicates that traffic is delivered to the node or pod with the destination set to the node&#39;s IP and node port or the pod&#39;s IP and port. Service implementations may use this information to adjust traffic routing.
         * 
         * @return builder
         * 
         */
        public Builder ipMode(@Nullable Output<String> ipMode) {
            $.ipMode = ipMode;
            return this;
        }

        /**
         * @param ipMode IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to &#34;VIP&#34; indicates that traffic is delivered to the node with the destination set to the load-balancer&#39;s IP and port. Setting this to &#34;Proxy&#34; indicates that traffic is delivered to the node or pod with the destination set to the node&#39;s IP and node port or the pod&#39;s IP and port. Service implementations may use this information to adjust traffic routing.
         * 
         * @return builder
         * 
         */
        public Builder ipMode(String ipMode) {
            return ipMode(Output.of(ipMode));
        }

        /**
         * @param ports Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
         * 
         * @return builder
         * 
         */
        public Builder ports(@Nullable Output<List<PortStatusArgs>> ports) {
            $.ports = ports;
            return this;
        }

        /**
         * @param ports Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
         * 
         * @return builder
         * 
         */
        public Builder ports(List<PortStatusArgs> ports) {
            return ports(Output.of(ports));
        }

        /**
         * @param ports Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
         * 
         * @return builder
         * 
         */
        public Builder ports(PortStatusArgs... ports) {
            return ports(List.of(ports));
        }

        public LoadBalancerIngressArgs build() {
            return $;
        }
    }

}
