// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.ModifyVolumeStatusPatchArgs;
import com.pulumi.kubernetes.core.v1.inputs.PersistentVolumeClaimConditionPatchArgs;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * PersistentVolumeClaimStatus is the current status of a persistent volume claim.
 * 
 */
public final class PersistentVolumeClaimStatusPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final PersistentVolumeClaimStatusPatchArgs Empty = new PersistentVolumeClaimStatusPatchArgs();

    /**
     * accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     * 
     */
    @Import(name="accessModes")
    private @Nullable Output<List<String>> accessModes;

    /**
     * @return accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     * 
     */
    public Optional<Output<List<String>>> accessModes() {
        return Optional.ofNullable(this.accessModes);
    }

    /**
     * allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
     * 	* Un-prefixed keys:
     * 		- storage - the capacity of the volume.
     * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
     * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
     * 
     * ClaimResourceStatus can be in any of following states:
     * 	- ControllerResizeInProgress:
     * 		State set when resize controller starts resizing the volume in control-plane.
     * 	- ControllerResizeFailed:
     * 		State set when resize has failed in resize controller with a terminal error.
     * 	- NodeResizePending:
     * 		State set when resize controller has finished resizing the volume but further resizing of
     * 		volume is needed on the node.
     * 	- NodeResizeInProgress:
     * 		State set when kubelet starts resizing the volume.
     * 	- NodeResizeFailed:
     * 		State set when resizing has failed in kubelet with a terminal error. Transient errors don&#39;t set
     * 		NodeResizeFailed.
     * For example: if expanding a PVC for more capacity - this field can be one of the following states:
     * 	- pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeInProgress&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeFailed&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizePending&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeInProgress&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeFailed&#34;
     * When this field is not set, it means that no resize operation is in progress for the given PVC.
     * 
     * A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
     * 
     * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
     * 
     */
    @Import(name="allocatedResourceStatuses")
    private @Nullable Output<Map<String,String>> allocatedResourceStatuses;

    /**
     * @return allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
     * 	* Un-prefixed keys:
     * 		- storage - the capacity of the volume.
     * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
     * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
     * 
     * ClaimResourceStatus can be in any of following states:
     * 	- ControllerResizeInProgress:
     * 		State set when resize controller starts resizing the volume in control-plane.
     * 	- ControllerResizeFailed:
     * 		State set when resize has failed in resize controller with a terminal error.
     * 	- NodeResizePending:
     * 		State set when resize controller has finished resizing the volume but further resizing of
     * 		volume is needed on the node.
     * 	- NodeResizeInProgress:
     * 		State set when kubelet starts resizing the volume.
     * 	- NodeResizeFailed:
     * 		State set when resizing has failed in kubelet with a terminal error. Transient errors don&#39;t set
     * 		NodeResizeFailed.
     * For example: if expanding a PVC for more capacity - this field can be one of the following states:
     * 	- pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeInProgress&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeFailed&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizePending&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeInProgress&#34;
     *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeFailed&#34;
     * When this field is not set, it means that no resize operation is in progress for the given PVC.
     * 
     * A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
     * 
     * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
     * 
     */
    public Optional<Output<Map<String,String>>> allocatedResourceStatuses() {
        return Optional.ofNullable(this.allocatedResourceStatuses);
    }

    /**
     * allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
     * 	* Un-prefixed keys:
     * 		- storage - the capacity of the volume.
     * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
     * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
     * 
     * Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.
     * 
     * A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
     * 
     * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
     * 
     */
    @Import(name="allocatedResources")
    private @Nullable Output<Map<String,String>> allocatedResources;

    /**
     * @return allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
     * 	* Un-prefixed keys:
     * 		- storage - the capacity of the volume.
     * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
     * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
     * 
     * Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.
     * 
     * A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
     * 
     * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
     * 
     */
    public Optional<Output<Map<String,String>>> allocatedResources() {
        return Optional.ofNullable(this.allocatedResources);
    }

    /**
     * capacity represents the actual resources of the underlying volume.
     * 
     */
    @Import(name="capacity")
    private @Nullable Output<Map<String,String>> capacity;

    /**
     * @return capacity represents the actual resources of the underlying volume.
     * 
     */
    public Optional<Output<Map<String,String>>> capacity() {
        return Optional.ofNullable(this.capacity);
    }

    /**
     * conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to &#39;Resizing&#39;.
     * 
     */
    @Import(name="conditions")
    private @Nullable Output<List<PersistentVolumeClaimConditionPatchArgs>> conditions;

    /**
     * @return conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to &#39;Resizing&#39;.
     * 
     */
    public Optional<Output<List<PersistentVolumeClaimConditionPatchArgs>>> conditions() {
        return Optional.ofNullable(this.conditions);
    }

    /**
     * currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
     * 
     */
    @Import(name="currentVolumeAttributesClassName")
    private @Nullable Output<String> currentVolumeAttributesClassName;

    /**
     * @return currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
     * 
     */
    public Optional<Output<String>> currentVolumeAttributesClassName() {
        return Optional.ofNullable(this.currentVolumeAttributesClassName);
    }

    /**
     * ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
     * 
     */
    @Import(name="modifyVolumeStatus")
    private @Nullable Output<ModifyVolumeStatusPatchArgs> modifyVolumeStatus;

    /**
     * @return ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
     * 
     */
    public Optional<Output<ModifyVolumeStatusPatchArgs>> modifyVolumeStatus() {
        return Optional.ofNullable(this.modifyVolumeStatus);
    }

    /**
     * phase represents the current phase of PersistentVolumeClaim.
     * 
     */
    @Import(name="phase")
    private @Nullable Output<String> phase;

    /**
     * @return phase represents the current phase of PersistentVolumeClaim.
     * 
     */
    public Optional<Output<String>> phase() {
        return Optional.ofNullable(this.phase);
    }

    /**
     * resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
     * 
     */
    @Import(name="resizeStatus")
    private @Nullable Output<String> resizeStatus;

    /**
     * @return resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
     * 
     */
    public Optional<Output<String>> resizeStatus() {
        return Optional.ofNullable(this.resizeStatus);
    }

    private PersistentVolumeClaimStatusPatchArgs() {}

    private PersistentVolumeClaimStatusPatchArgs(PersistentVolumeClaimStatusPatchArgs $) {
        this.accessModes = $.accessModes;
        this.allocatedResourceStatuses = $.allocatedResourceStatuses;
        this.allocatedResources = $.allocatedResources;
        this.capacity = $.capacity;
        this.conditions = $.conditions;
        this.currentVolumeAttributesClassName = $.currentVolumeAttributesClassName;
        this.modifyVolumeStatus = $.modifyVolumeStatus;
        this.phase = $.phase;
        this.resizeStatus = $.resizeStatus;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PersistentVolumeClaimStatusPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PersistentVolumeClaimStatusPatchArgs $;

        public Builder() {
            $ = new PersistentVolumeClaimStatusPatchArgs();
        }

        public Builder(PersistentVolumeClaimStatusPatchArgs defaults) {
            $ = new PersistentVolumeClaimStatusPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessModes accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
         * 
         * @return builder
         * 
         */
        public Builder accessModes(@Nullable Output<List<String>> accessModes) {
            $.accessModes = accessModes;
            return this;
        }

        /**
         * @param accessModes accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
         * 
         * @return builder
         * 
         */
        public Builder accessModes(List<String> accessModes) {
            return accessModes(Output.of(accessModes));
        }

        /**
         * @param accessModes accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
         * 
         * @return builder
         * 
         */
        public Builder accessModes(String... accessModes) {
            return accessModes(List.of(accessModes));
        }

        /**
         * @param allocatedResourceStatuses allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
         * 	* Un-prefixed keys:
         * 		- storage - the capacity of the volume.
         * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
         * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
         * 
         * ClaimResourceStatus can be in any of following states:
         * 	- ControllerResizeInProgress:
         * 		State set when resize controller starts resizing the volume in control-plane.
         * 	- ControllerResizeFailed:
         * 		State set when resize has failed in resize controller with a terminal error.
         * 	- NodeResizePending:
         * 		State set when resize controller has finished resizing the volume but further resizing of
         * 		volume is needed on the node.
         * 	- NodeResizeInProgress:
         * 		State set when kubelet starts resizing the volume.
         * 	- NodeResizeFailed:
         * 		State set when resizing has failed in kubelet with a terminal error. Transient errors don&#39;t set
         * 		NodeResizeFailed.
         * For example: if expanding a PVC for more capacity - this field can be one of the following states:
         * 	- pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeInProgress&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeFailed&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizePending&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeInProgress&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeFailed&#34;
         * When this field is not set, it means that no resize operation is in progress for the given PVC.
         * 
         * A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
         * 
         * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResourceStatuses(@Nullable Output<Map<String,String>> allocatedResourceStatuses) {
            $.allocatedResourceStatuses = allocatedResourceStatuses;
            return this;
        }

        /**
         * @param allocatedResourceStatuses allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
         * 	* Un-prefixed keys:
         * 		- storage - the capacity of the volume.
         * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
         * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
         * 
         * ClaimResourceStatus can be in any of following states:
         * 	- ControllerResizeInProgress:
         * 		State set when resize controller starts resizing the volume in control-plane.
         * 	- ControllerResizeFailed:
         * 		State set when resize has failed in resize controller with a terminal error.
         * 	- NodeResizePending:
         * 		State set when resize controller has finished resizing the volume but further resizing of
         * 		volume is needed on the node.
         * 	- NodeResizeInProgress:
         * 		State set when kubelet starts resizing the volume.
         * 	- NodeResizeFailed:
         * 		State set when resizing has failed in kubelet with a terminal error. Transient errors don&#39;t set
         * 		NodeResizeFailed.
         * For example: if expanding a PVC for more capacity - this field can be one of the following states:
         * 	- pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeInProgress&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;ControllerResizeFailed&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizePending&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeInProgress&#34;
         *      - pvc.status.allocatedResourceStatus[&#39;storage&#39;] = &#34;NodeResizeFailed&#34;
         * When this field is not set, it means that no resize operation is in progress for the given PVC.
         * 
         * A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
         * 
         * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResourceStatuses(Map<String,String> allocatedResourceStatuses) {
            return allocatedResourceStatuses(Output.of(allocatedResourceStatuses));
        }

        /**
         * @param allocatedResources allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
         * 	* Un-prefixed keys:
         * 		- storage - the capacity of the volume.
         * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
         * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
         * 
         * Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.
         * 
         * A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
         * 
         * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResources(@Nullable Output<Map<String,String>> allocatedResources) {
            $.allocatedResources = allocatedResources;
            return this;
        }

        /**
         * @param allocatedResources allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
         * 	* Un-prefixed keys:
         * 		- storage - the capacity of the volume.
         * 	* Custom resources must use implementation-defined prefixed names such as &#34;example.com/my-custom-resource&#34;
         * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
         * 
         * Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.
         * 
         * A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
         * 
         * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
         * 
         * @return builder
         * 
         */
        public Builder allocatedResources(Map<String,String> allocatedResources) {
            return allocatedResources(Output.of(allocatedResources));
        }

        /**
         * @param capacity capacity represents the actual resources of the underlying volume.
         * 
         * @return builder
         * 
         */
        public Builder capacity(@Nullable Output<Map<String,String>> capacity) {
            $.capacity = capacity;
            return this;
        }

        /**
         * @param capacity capacity represents the actual resources of the underlying volume.
         * 
         * @return builder
         * 
         */
        public Builder capacity(Map<String,String> capacity) {
            return capacity(Output.of(capacity));
        }

        /**
         * @param conditions conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to &#39;Resizing&#39;.
         * 
         * @return builder
         * 
         */
        public Builder conditions(@Nullable Output<List<PersistentVolumeClaimConditionPatchArgs>> conditions) {
            $.conditions = conditions;
            return this;
        }

        /**
         * @param conditions conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to &#39;Resizing&#39;.
         * 
         * @return builder
         * 
         */
        public Builder conditions(List<PersistentVolumeClaimConditionPatchArgs> conditions) {
            return conditions(Output.of(conditions));
        }

        /**
         * @param conditions conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to &#39;Resizing&#39;.
         * 
         * @return builder
         * 
         */
        public Builder conditions(PersistentVolumeClaimConditionPatchArgs... conditions) {
            return conditions(List.of(conditions));
        }

        /**
         * @param currentVolumeAttributesClassName currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
         * 
         * @return builder
         * 
         */
        public Builder currentVolumeAttributesClassName(@Nullable Output<String> currentVolumeAttributesClassName) {
            $.currentVolumeAttributesClassName = currentVolumeAttributesClassName;
            return this;
        }

        /**
         * @param currentVolumeAttributesClassName currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
         * 
         * @return builder
         * 
         */
        public Builder currentVolumeAttributesClassName(String currentVolumeAttributesClassName) {
            return currentVolumeAttributesClassName(Output.of(currentVolumeAttributesClassName));
        }

        /**
         * @param modifyVolumeStatus ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
         * 
         * @return builder
         * 
         */
        public Builder modifyVolumeStatus(@Nullable Output<ModifyVolumeStatusPatchArgs> modifyVolumeStatus) {
            $.modifyVolumeStatus = modifyVolumeStatus;
            return this;
        }

        /**
         * @param modifyVolumeStatus ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
         * 
         * @return builder
         * 
         */
        public Builder modifyVolumeStatus(ModifyVolumeStatusPatchArgs modifyVolumeStatus) {
            return modifyVolumeStatus(Output.of(modifyVolumeStatus));
        }

        /**
         * @param phase phase represents the current phase of PersistentVolumeClaim.
         * 
         * @return builder
         * 
         */
        public Builder phase(@Nullable Output<String> phase) {
            $.phase = phase;
            return this;
        }

        /**
         * @param phase phase represents the current phase of PersistentVolumeClaim.
         * 
         * @return builder
         * 
         */
        public Builder phase(String phase) {
            return phase(Output.of(phase));
        }

        /**
         * @param resizeStatus resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
         * 
         * @return builder
         * 
         */
        public Builder resizeStatus(@Nullable Output<String> resizeStatus) {
            $.resizeStatus = resizeStatus;
            return this;
        }

        /**
         * @param resizeStatus resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
         * 
         * @return builder
         * 
         */
        public Builder resizeStatus(String resizeStatus) {
            return resizeStatus(Output.of(resizeStatus));
        }

        public PersistentVolumeClaimStatusPatchArgs build() {
            return $;
        }
    }

}
