// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.PodDNSConfigOptionArgs;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.
 * 
 */
public final class PodDNSConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final PodDNSConfigArgs Empty = new PodDNSConfigArgs();

    /**
     * A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
     * 
     */
    @Import(name="nameservers")
    private @Nullable Output<List<String>> nameservers;

    /**
     * @return A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
     * 
     */
    public Optional<Output<List<String>>> nameservers() {
        return Optional.ofNullable(this.nameservers);
    }

    /**
     * A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
     * 
     */
    @Import(name="options")
    private @Nullable Output<List<PodDNSConfigOptionArgs>> options;

    /**
     * @return A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
     * 
     */
    public Optional<Output<List<PodDNSConfigOptionArgs>>> options() {
        return Optional.ofNullable(this.options);
    }

    /**
     * A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
     * 
     */
    @Import(name="searches")
    private @Nullable Output<List<String>> searches;

    /**
     * @return A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
     * 
     */
    public Optional<Output<List<String>>> searches() {
        return Optional.ofNullable(this.searches);
    }

    private PodDNSConfigArgs() {}

    private PodDNSConfigArgs(PodDNSConfigArgs $) {
        this.nameservers = $.nameservers;
        this.options = $.options;
        this.searches = $.searches;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PodDNSConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PodDNSConfigArgs $;

        public Builder() {
            $ = new PodDNSConfigArgs();
        }

        public Builder(PodDNSConfigArgs defaults) {
            $ = new PodDNSConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param nameservers A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
         * 
         * @return builder
         * 
         */
        public Builder nameservers(@Nullable Output<List<String>> nameservers) {
            $.nameservers = nameservers;
            return this;
        }

        /**
         * @param nameservers A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
         * 
         * @return builder
         * 
         */
        public Builder nameservers(List<String> nameservers) {
            return nameservers(Output.of(nameservers));
        }

        /**
         * @param nameservers A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
         * 
         * @return builder
         * 
         */
        public Builder nameservers(String... nameservers) {
            return nameservers(List.of(nameservers));
        }

        /**
         * @param options A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
         * 
         * @return builder
         * 
         */
        public Builder options(@Nullable Output<List<PodDNSConfigOptionArgs>> options) {
            $.options = options;
            return this;
        }

        /**
         * @param options A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
         * 
         * @return builder
         * 
         */
        public Builder options(List<PodDNSConfigOptionArgs> options) {
            return options(Output.of(options));
        }

        /**
         * @param options A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
         * 
         * @return builder
         * 
         */
        public Builder options(PodDNSConfigOptionArgs... options) {
            return options(List.of(options));
        }

        /**
         * @param searches A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
         * 
         * @return builder
         * 
         */
        public Builder searches(@Nullable Output<List<String>> searches) {
            $.searches = searches;
            return this;
        }

        /**
         * @param searches A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
         * 
         * @return builder
         * 
         */
        public Builder searches(List<String> searches) {
            return searches(Output.of(searches));
        }

        /**
         * @param searches A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
         * 
         * @return builder
         * 
         */
        public Builder searches(String... searches) {
            return searches(List.of(searches));
        }

        public PodDNSConfigArgs build() {
            return $;
        }
    }

}
