// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.ClaimSourcePatchArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * PodResourceClaim references exactly one ResourceClaim, either directly or by naming a ResourceClaimTemplate which is then turned into a ResourceClaim for the pod.
 * 
 * It adds a name to it that uniquely identifies the ResourceClaim inside the Pod. Containers that need access to the ResourceClaim reference it with this name.
 * 
 */
public final class PodResourceClaimPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final PodResourceClaimPatchArgs Empty = new PodResourceClaimPatchArgs();

    /**
     * Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
     * 
     * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
     * 
     */
    @Import(name="resourceClaimName")
    private @Nullable Output<String> resourceClaimName;

    /**
     * @return ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
     * 
     * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
     * 
     */
    public Optional<Output<String>> resourceClaimName() {
        return Optional.ofNullable(this.resourceClaimName);
    }

    /**
     * ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.
     * 
     * The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.
     * 
     * This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
     * 
     * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
     * 
     */
    @Import(name="resourceClaimTemplateName")
    private @Nullable Output<String> resourceClaimTemplateName;

    /**
     * @return ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.
     * 
     * The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.
     * 
     * This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
     * 
     * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
     * 
     */
    public Optional<Output<String>> resourceClaimTemplateName() {
        return Optional.ofNullable(this.resourceClaimTemplateName);
    }

    /**
     * Source describes where to find the ResourceClaim.
     * 
     */
    @Import(name="source")
    private @Nullable Output<ClaimSourcePatchArgs> source;

    /**
     * @return Source describes where to find the ResourceClaim.
     * 
     */
    public Optional<Output<ClaimSourcePatchArgs>> source() {
        return Optional.ofNullable(this.source);
    }

    private PodResourceClaimPatchArgs() {}

    private PodResourceClaimPatchArgs(PodResourceClaimPatchArgs $) {
        this.name = $.name;
        this.resourceClaimName = $.resourceClaimName;
        this.resourceClaimTemplateName = $.resourceClaimTemplateName;
        this.source = $.source;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PodResourceClaimPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PodResourceClaimPatchArgs $;

        public Builder() {
            $ = new PodResourceClaimPatchArgs();
        }

        public Builder(PodResourceClaimPatchArgs defaults) {
            $ = new PodResourceClaimPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param resourceClaimName ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
         * 
         * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
         * 
         * @return builder
         * 
         */
        public Builder resourceClaimName(@Nullable Output<String> resourceClaimName) {
            $.resourceClaimName = resourceClaimName;
            return this;
        }

        /**
         * @param resourceClaimName ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
         * 
         * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
         * 
         * @return builder
         * 
         */
        public Builder resourceClaimName(String resourceClaimName) {
            return resourceClaimName(Output.of(resourceClaimName));
        }

        /**
         * @param resourceClaimTemplateName ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.
         * 
         * The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.
         * 
         * This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
         * 
         * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
         * 
         * @return builder
         * 
         */
        public Builder resourceClaimTemplateName(@Nullable Output<String> resourceClaimTemplateName) {
            $.resourceClaimTemplateName = resourceClaimTemplateName;
            return this;
        }

        /**
         * @param resourceClaimTemplateName ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.
         * 
         * The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.
         * 
         * This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
         * 
         * Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.
         * 
         * @return builder
         * 
         */
        public Builder resourceClaimTemplateName(String resourceClaimTemplateName) {
            return resourceClaimTemplateName(Output.of(resourceClaimTemplateName));
        }

        /**
         * @param source Source describes where to find the ResourceClaim.
         * 
         * @return builder
         * 
         */
        public Builder source(@Nullable Output<ClaimSourcePatchArgs> source) {
            $.source = source;
            return this;
        }

        /**
         * @param source Source describes where to find the ResourceClaim.
         * 
         * @return builder
         * 
         */
        public Builder source(ClaimSourcePatchArgs source) {
            return source(Output.of(source));
        }

        public PodResourceClaimPatchArgs build() {
            return $;
        }
    }

}
